/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns.server;

import com.eatthepath.pushy.apns.server.BaseHttp2ServerBuilder;
import com.eatthepath.pushy.apns.server.MockApnsServer;
import com.eatthepath.pushy.apns.server.MockApnsServerListener;
import com.eatthepath.pushy.apns.server.PushNotificationHandlerFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;

public class MockApnsServerBuilder
extends BaseHttp2ServerBuilder<MockApnsServer> {
    private PushNotificationHandlerFactory handlerFactory;
    private MockApnsServerListener listener;

    @Override
    public MockApnsServerBuilder setServerCredentials(File certificatePemFile, File privateKeyPkcs8File, String privateKeyPassword) {
        super.setServerCredentials(certificatePemFile, privateKeyPkcs8File, privateKeyPassword);
        return this;
    }

    @Override
    public MockApnsServerBuilder setServerCredentials(InputStream certificatePemInputStream, InputStream privateKeyPkcs8InputStream, String privateKeyPassword) {
        super.setServerCredentials(certificatePemInputStream, privateKeyPkcs8InputStream, privateKeyPassword);
        return this;
    }

    @Override
    public MockApnsServerBuilder setServerCredentials(X509Certificate[] certificates, PrivateKey privateKey, String privateKeyPassword) {
        super.setServerCredentials(certificates, privateKey, privateKeyPassword);
        return this;
    }

    @Override
    public MockApnsServerBuilder setTrustedClientCertificateChain(File certificatePemFile) {
        super.setTrustedClientCertificateChain(certificatePemFile);
        return this;
    }

    @Override
    public MockApnsServerBuilder setTrustedClientCertificateChain(InputStream certificateInputStream) {
        super.setTrustedClientCertificateChain(certificateInputStream);
        return this;
    }

    @Override
    public MockApnsServerBuilder setTrustedServerCertificateChain(X509Certificate ... certificates) {
        super.setTrustedServerCertificateChain(certificates);
        return this;
    }

    @Override
    public MockApnsServerBuilder setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        super.setEventLoopGroup(eventLoopGroup);
        return this;
    }

    @Override
    public MockApnsServerBuilder setMaxConcurrentStreams(int maxConcurrentStreams) {
        super.setMaxConcurrentStreams(maxConcurrentStreams);
        return this;
    }

    @Override
    public MockApnsServerBuilder setUseAlpn(boolean useAlpn) {
        super.setUseAlpn(useAlpn);
        return this;
    }

    public MockApnsServerBuilder setHandlerFactory(PushNotificationHandlerFactory handlerFactory) {
        this.handlerFactory = handlerFactory;
        return this;
    }

    public MockApnsServerBuilder setListener(MockApnsServerListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public MockApnsServer build() throws SSLException {
        return (MockApnsServer)super.build();
    }

    @Override
    protected MockApnsServer constructServer(SslContext sslContext) {
        if (this.handlerFactory == null) {
            throw new IllegalStateException("Must provide a push notification handler factory before building a mock server.");
        }
        return new MockApnsServer(sslContext, this.eventLoopGroup, this.handlerFactory, this.listener, this.maxConcurrentStreams);
    }
}

