/*
 * Decompiled with CFR 0.152.
 */
package com.eaglexad.lib.http.tool;

import android.net.Uri;
import android.os.Build;
import com.eaglexad.lib.http.ExHttp;
import com.eaglexad.lib.http.entry.ExRequest;
import com.eaglexad.lib.http.entry.ExResponse;
import com.eaglexad.lib.http.exception.ErrorConnection;
import com.eaglexad.lib.http.ible.IExHttpStack;
import com.eaglexad.lib.http.ible.IExRequestBody;
import com.eaglexad.lib.http.tool.ExHttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

public class ExHttpStackRequest
implements IExHttpStack {
    private ExRequest mRequest;
    private String mUrl;
    private Map<String, String> mAdditionalHeaders;
    private HttpURLConnection mConnection;
    private InputStream mInputStream;

    @Override
    public ExResponse performRequest(ExRequest request, Map<String, String> additionalHeaders) throws ErrorConnection {
        this.mRequest = request;
        this.mAdditionalHeaders = additionalHeaders;
        this.mUrl = this.initUrl();
        ExResponse.Builder builder = new ExResponse.Builder(request.what);
        builder.setReuest(request);
        try {
            this.prepare();
            this.openConnection();
            this.initHeader();
            this.writeBody();
            int responseCode = this.getResponseCode();
            byte[] data = new byte[]{};
            if (responseCode == 200) {
                this.mInputStream = this.mConnection.getInputStream();
                if (!ExHttpUtils.isEmpty(this.mInputStream)) {
                    data = ExHttpUtils.inputStreamToBytes(this.mInputStream, this.getContentLength());
                }
                builder.setIsSuccess();
            }
            if (responseCode >= 300) {
                this.mInputStream = this.mConnection.getErrorStream();
                if (this.mInputStream != null) {
                    data = ExHttpUtils.inputStreamToBytes(this.mInputStream, this.getContentLength());
                }
            }
            if (data.length > 0) {
                builder.setData(data);
            }
            builder.setContentLength(this.getContentLength());
            builder.setLastModified(this.getLastModified());
            builder.setExpiration(this.getExpiration());
            builder.setETag(this.getETag());
            builder.setResponseMessage(this.getResponseMessage());
            builder.setResponseCode(responseCode);
            builder.setResponseHeaders(this.getResponseHeaders());
        }
        catch (IOException e) {
            throw new ErrorConnection(e.getMessage(), e);
        }
        finally {
            this.close();
        }
        return builder.builder();
    }

    @Override
    public void close() {
        if (this.mInputStream != null) {
            ExHttpUtils.closeQuietly(this.mInputStream);
        }
        if (this.mConnection != null) {
            this.mConnection.disconnect();
        }
    }

    private String initUrl() {
        String uri = this.mRequest.url;
        StringBuilder queryBuilder = new StringBuilder(uri);
        if (!uri.contains("?")) {
            queryBuilder.append("?");
        } else if (!uri.endsWith("?")) {
            queryBuilder.append("&");
        }
        List<ExRequest.KeyValue> queryParams = this.mRequest.queryStringParams;
        if (!ExHttpUtils.isEmpty(queryParams)) {
            for (ExRequest.KeyValue kv : queryParams) {
                String name = kv.key;
                String value = kv.getValueStr();
                if (ExHttpUtils.isEmpty(name) || value == null) continue;
                queryBuilder.append(Uri.encode((String)name, (String)this.mRequest.charset));
                queryBuilder.append("=");
                queryBuilder.append(Uri.encode((String)value, (String)this.mRequest.charset));
                queryBuilder.append("&");
            }
        }
        if (queryBuilder.charAt(queryBuilder.length() - 1) == '&') {
            queryBuilder.deleteCharAt(queryBuilder.length() - 1);
        }
        if (queryBuilder.charAt(queryBuilder.length() - 1) == '?') {
            queryBuilder.deleteCharAt(queryBuilder.length() - 1);
        }
        return queryBuilder.toString();
    }

    private void prepare() {
    }

    private void openConnection() throws IOException {
        SSLSocketFactory sslSocketFactory;
        URL url = new URL(this.mUrl);
        Proxy proxy = this.mRequest.proxy;
        this.mConnection = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        this.mConnection.setReadTimeout(this.mRequest.connectTimeout);
        this.mConnection.setConnectTimeout(this.mRequest.connectTimeout);
        this.mConnection.setInstanceFollowRedirects(this.mRequest.getRedirectIEx() == null);
        if (this.mConnection instanceof HttpsURLConnection && (sslSocketFactory = this.mRequest.sslSocketFactory) != null) {
            ((HttpsURLConnection)this.mConnection).setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return ((ExHttpStackRequest)ExHttpStackRequest.this).mRequest.hostNameVerify;
                }
            });
            ((HttpsURLConnection)this.mConnection).setSSLSocketFactory(sslSocketFactory);
        }
    }

    private void initHeader() {
        List<ExRequest.Header> headers = this.mRequest.headers;
        if (headers != null) {
            for (ExRequest.Header header : headers) {
                String name = header.key;
                String value = header.getValueStr();
                if (ExHttpUtils.isEmpty(name) || ExHttpUtils.isEmpty(value)) continue;
                if (header.setHeader) {
                    this.mConnection.setRequestProperty(name, value);
                    continue;
                }
                this.mConnection.addRequestProperty(name, value);
            }
        }
        if (this.mAdditionalHeaders != null && this.mAdditionalHeaders.size() > 0) {
            for (String key : this.mAdditionalHeaders.keySet()) {
                String value = this.mAdditionalHeaders.get(key);
                if (ExHttpUtils.isEmpty(value)) continue;
                this.mConnection.addRequestProperty(key, value);
            }
        }
    }

    private void writeBody() throws IOException {
        IExRequestBody body;
        ExHttp.Method method = this.mRequest.method;
        this.mConnection.setRequestMethod(method.toString());
        if (ExHttp.Method.permitsRequestBody(method) && (body = this.mRequest.getRequestBody()) != null) {
            long contentLength;
            String contentType = body.getContentType();
            if (!ExHttpUtils.isEmpty(contentType)) {
                this.mConnection.setRequestProperty("Content-Type", contentType);
            }
            if ((contentLength = body.getContentLength()) < 0L) {
                this.mConnection.setChunkedStreamingMode(262144);
            } else if (contentLength < Integer.MAX_VALUE) {
                this.mConnection.setFixedLengthStreamingMode((int)contentLength);
            } else if (Build.VERSION.SDK_INT >= 19) {
                this.mConnection.setFixedLengthStreamingMode(contentLength);
            } else {
                this.mConnection.setChunkedStreamingMode(262144);
            }
            this.mConnection.setRequestProperty("Content-Length", String.valueOf(contentLength));
            this.mConnection.setDoOutput(true);
            body.writeTo(this.mConnection.getOutputStream());
        }
    }

    private long getContentLength() {
        long result = 0L;
        if (this.mConnection != null) {
            try {
                result = this.mConnection.getContentLength();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (result < 1L) {
                try {
                    result = this.mInputStream.available();
                }
                catch (Throwable throwable) {}
            }
        } else {
            try {
                result = this.mInputStream.available();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    private long getExpiration() {
        if (this.mConnection == null) {
            return -1L;
        }
        long expiration = -1L;
        String cacheControl = this.mConnection.getHeaderField("Cache-Control");
        if (!ExHttpUtils.isEmpty(cacheControl)) {
            StringTokenizer tok = new StringTokenizer(cacheControl, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken().trim().toLowerCase();
                if (!token.startsWith("max-age")) continue;
                int eqIdx = token.indexOf(61);
                if (eqIdx <= 0) break;
                try {
                    String value = token.substring(eqIdx + 1).trim();
                    long seconds = Long.parseLong(value);
                    if (seconds <= 0L) break;
                    expiration = System.currentTimeMillis() + seconds * 1000L;
                }
                catch (Throwable throwable) {}
                break;
            }
        }
        if (expiration <= 0L) {
            expiration = this.mConnection.getExpiration();
        }
        if (expiration <= 0L) {
            expiration = System.currentTimeMillis() + (long)this.mRequest.cacheMaxAge;
        }
        if (expiration <= 0L) {
            expiration = Long.MAX_VALUE;
        }
        return expiration;
    }

    private long getLastModified() {
        return this.mConnection == null ? System.currentTimeMillis() : this.mConnection.getHeaderFieldDate("Last-Modified", System.currentTimeMillis());
    }

    private String getETag() {
        return this.mConnection == null ? null : this.mConnection.getHeaderField("ETag");
    }

    private Map<String, List<String>> getResponseHeaders() {
        return this.mConnection == null ? null : this.mConnection.getHeaderFields();
    }

    private int getResponseCode() throws IOException {
        return this.mConnection == null ? -1 : this.mConnection.getResponseCode();
    }

    private String getResponseMessage() throws IOException {
        return this.mConnection == null ? null : URLDecoder.decode(this.mConnection.getResponseMessage(), this.mRequest.charset);
    }
}

