/*
 * Decompiled with CFR 0.152.
 */
package com.eaglexad.lib.http.entry;

import com.eaglexad.lib.http.entry.ExResponse;
import com.eaglexad.lib.http.exception.ErrorConnection;
import com.eaglexad.lib.http.exception.ErrorConnectionRedirect;
import com.eaglexad.lib.http.exception.ErrorNetwork;
import com.eaglexad.lib.http.exception.ErrorServer;
import com.eaglexad.lib.http.exception.ErrorTimeout;
import com.eaglexad.lib.http.exception.ExHttpException;

public class ExError {
    public static int EX_ERROR_DEFAULT = -1;
    public static int EX_ERROR_CONNECTION = -2;
    public static int EX_ERROR_CONNECTION_REDIRECT = -3;
    public static int EX_ERROR_NETWORK = -4;
    public static int EX_ERROR_SERVER = -5;
    public static int EX_ERROR_TIMEOUT = -6;
    public int what = -1;
    public long startTime;
    public long endTime;
    public long requestTime;
    public int responseCode = EX_ERROR_DEFAULT;
    public String responseMessage = "";

    private ExError() {
    }

    public static ExError newInstance(ExHttpException httpException) {
        ExError error = new ExError();
        if (httpException instanceof ErrorConnection) {
            error.responseCode = EX_ERROR_CONNECTION;
        }
        if (httpException instanceof ErrorConnectionRedirect) {
            error.responseCode = EX_ERROR_CONNECTION_REDIRECT;
        }
        if (httpException instanceof ErrorNetwork) {
            error.responseCode = EX_ERROR_NETWORK;
        }
        if (httpException instanceof ErrorServer) {
            error.responseCode = EX_ERROR_SERVER;
        }
        if (httpException instanceof ErrorTimeout) {
            error.responseCode = EX_ERROR_TIMEOUT;
        }
        error.responseMessage = httpException.getMessage();
        return error;
    }

    public static ExError newInstance(ExResponse response) {
        ExError error = new ExError();
        error.what = response.what;
        error.responseCode = response.responseCode;
        error.responseMessage = response.responseMessage;
        error.requestTime = response.requestTime;
        error.startTime = response.startTime;
        error.endTime = response.endTime;
        return error;
    }
}

