/*
 * Decompiled with CFR 0.152.
 */
package com.eaglexad.lib.http.body;

import com.eaglexad.lib.http.ible.IExRequestBody;
import com.eaglexad.lib.http.tool.ExHttpUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ExStringBody
implements IExRequestBody {
    private byte[] mContent;
    private String mContentType;
    private String mCharset = "UTF-8";

    public ExStringBody(String content, String charset) throws UnsupportedEncodingException {
        if (!ExHttpUtils.isEmpty(charset)) {
            this.mCharset = charset;
        }
        this.mContent = content.getBytes(this.mCharset);
    }

    @Override
    public long getContentLength() {
        return this.mContent.length;
    }

    @Override
    public void setContentType(String contentType) {
        if (!ExHttpUtils.isEmpty(contentType)) {
            this.mContentType = contentType;
        }
    }

    @Override
    public String getContentType() {
        if (!ExHttpUtils.isEmpty(this.mContentType)) {
            this.mContentType = "application/json;charset=" + this.mCharset;
        }
        return this.mContentType;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (!ExHttpUtils.isEmpty(this.mContent)) {
            out.write(this.mContent);
        }
        out.flush();
    }
}

