/*
 * Decompiled with CFR 0.152.
 */
package com.eaglexad.lib.http.body;

import com.eaglexad.lib.http.ible.IExRequestBody;
import com.eaglexad.lib.http.tool.ExHttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExInputStreamBody
implements IExRequestBody {
    private InputStream mContent;
    private String mContentType;
    private final long mTotal;
    private long mCurrent = 0L;

    public ExInputStreamBody(InputStream inputStream) {
        this(inputStream, null);
    }

    public ExInputStreamBody(InputStream inputStream, String contentType) {
        this.mContent = inputStream;
        this.mContentType = contentType;
        this.mTotal = ExHttpUtils.getInputStreamLength(inputStream);
    }

    @Override
    public long getContentLength() {
        return this.mTotal;
    }

    @Override
    public void setContentType(String contentType) {
        if (!ExHttpUtils.isEmpty(contentType)) {
            this.mContentType = contentType;
        }
    }

    @Override
    public String getContentType() {
        if (!ExHttpUtils.isEmpty(this.mContentType)) {
            this.mContentType = "application/octet-stream";
        }
        return this.mContentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            int len = 0;
            while ((len = this.mContent.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                this.mCurrent += (long)len;
            }
            out.flush();
        }
        finally {
            ExHttpUtils.closeQuietly(this.mContent);
        }
    }
}

