/*
 * Copyright (c) 2014 by EagleXad
 * Team: EagleXad
 * Create: 2014-08-29
 */

package com.eaglexad.lib.http.ible;

import com.eaglexad.lib.http.ExHttp;
import com.eaglexad.lib.http.entry.ExRequest;

import java.io.File;
import java.util.List;
import java.util.Map;

/**
 * @author Aloneter
 * @ClassName: IExHttpMethod
 * @Description:
 */
public interface IExHttpMethod {

    // this is request method
    ExRequest request(int what, String url, ExHttp.Method method, Object remark, ExHttp.RequestCallback callback);

    // this is request method , use bodyParams
    ExRequest request(int what, String url, ExHttp.Method method, Map<String, Object> bodyParams, Object remark, ExHttp.RequestCallback callback);

    ExRequest request(int what, String url, ExHttp.Method method, Map<String, Object> bodyParams, ExHttp.CacheType cacheType, Object remark, ExHttp.RequestCallback callback);

    ExRequest request(int what, String url, ExHttp.Method method, Map<String, String> queryParams, Map<String, Object> bodyParams, Object remark, ExHttp.RequestCallback callback);

    ExRequest request(int what, String url, ExHttp.Method method, Map<String, String> queryParams, Map<String, Object> bodyParams, ExHttp.CacheType cacheType, Object remark, ExHttp.RequestCallback callback);

    // this is request method , use bodyContent
    ExRequest request(int what, String url, ExHttp.Method method, String bodyContent, Object remark, ExHttp.RequestCallback callback);

    ExRequest request(int what, String url, ExHttp.Method method, String bodyContent, ExHttp.CacheType cacheType, Object remark, ExHttp.RequestCallback callback);

    ExRequest request(int what, String url, ExHttp.Method method, Map<String, String> queryParams, String bodyContent, Object remark, ExHttp.RequestCallback callback);

    ExRequest request(int what, String url, ExHttp.Method method, Map<String, String> queryParams, String bodyContent, ExHttp.CacheType cacheType, Object remark, ExHttp.RequestCallback callback);

    ExRequest request(int what, String url, ExHttp.Method method, Map<String, String> queryParams, Map<String, Object> bodyParams, String bodyContent, ExHttp.CacheType cacheType, Object remark, ExHttp.RequestCallback callback);

    // this is request sync method
    ExRequest execute(int what, String url, ExHttp.Method method, Object remark, ExHttp.RequestCallback callback);

    // this is request sync method , use bodyParams
    ExRequest execute(int what, String url, ExHttp.Method method, Map<String, Object> bodyParams, Object remark, ExHttp.RequestCallback callback);

    ExRequest execute(int what, String url, ExHttp.Method method, Map<String, Object> bodyParams, ExHttp.CacheType cacheType, Object remark, ExHttp.RequestCallback callback);

    ExRequest execute(int what, String url, ExHttp.Method method, Map<String, String> queryParams, Map<String, Object> bodyParams, Object remark, ExHttp.RequestCallback callback);

    ExRequest execute(int what, String url, ExHttp.Method method, Map<String, String> queryParams, Map<String, Object> bodyParams, ExHttp.CacheType cacheType, Object remark, ExHttp.RequestCallback callback);

    // this is request sync method , use bodyContent
    ExRequest execute(int what, String url, ExHttp.Method method, String bodyContent, Object remark, ExHttp.RequestCallback callback);

    ExRequest execute(int what, String url, ExHttp.Method method, String bodyContent, ExHttp.CacheType cacheType, Object remark, ExHttp.RequestCallback callback);

    ExRequest execute(int what, String url, ExHttp.Method method, Map<String, String> queryParams, String bodyContent, Object remark, ExHttp.RequestCallback callback);

    ExRequest execute(int what, String url, ExHttp.Method method, Map<String, String> queryParams, String bodyContent, ExHttp.CacheType cacheType, Object remark, ExHttp.RequestCallback callback);

    ExRequest execute(int what, String url, ExHttp.Method method, Map<String, String> queryParams, Map<String, Object> bodyParams, String bodyContent, ExHttp.CacheType cacheType, Object remark, ExHttp.RequestCallback callback);

    // this is download method
    ExRequest download(int what, String url, Object remark, ExHttp.DownloadCallback callback);

    ExRequest download(int what, String url, Map<String, String> queryParams, Object remark, ExHttp.DownloadCallback callback);

    ExRequest download(int what, String url, File file, Object remark, ExHttp.DownloadCallback callback);

    ExRequest download(int what, String url, Map<String, String> queryParams, File file, Object remark, ExHttp.DownloadCallback callback);

    ExRequest download(int what, String url, String name, String saveFilePath, String ext, Object remark, ExHttp.DownloadCallback callback);

    ExRequest download(int what, String url, Map<String, String> queryParams, String name, String saveFilePath, String ext, Object remark, ExHttp.DownloadCallback callback);

    // this is upload method
    ExRequest upload(int what, String url, Map<String, File> files, Object remark, ExHttp.UploadCallback callback);

    ExRequest upload(int what, String url, Map<String, String> queryParams, Map<String, File> files, Object remark, ExHttp.UploadCallback callback);

    ExRequest upload(int what, String url, File file, Object remark, ExHttp.UploadCallback callback);

    ExRequest upload(int what, String url, Map<String, String> queryParams, File file, Object remark, ExHttp.UploadCallback callback);

    ExRequest upload(int what, String url, String fileName, List<File> files, Object remark, ExHttp.UploadCallback callback);

    ExRequest upload(int what, String url, Map<String, String> queryParams, String fileName, List<File> files, Object remark, ExHttp.UploadCallback callback);

}
