/*
 * Copyright (c) 2014 by EagleXad
 * Team: EagleXad
 * Create: 2014-08-29
 */

package com.eaglexad.lib.http.entry;

import java.util.List;
import java.util.Map;

/**
 * @author Aloneter
 * @ClassName: ExResponse
 * @Description:
 */
public class ExResponse {

    public int what = ExRequest.DEFAULT_WHAT;
    public byte[] data;
    public Object response;
    public Object remark;

    public boolean isCache;
    public boolean isSuccess;

    public long startTime;
    public long endTime;
    public long requestTime;

    public long contentLength;
    public long lastModified;
    public long expiration;
    public String eTag = "";
    public int responseCode;
    public String responseMessage = "";
    public Map<String, List<String>> responseHeaders;

    private ExResponse(Builder builder) {

        this.what = builder.what;
        this.data = builder.data;
        this.response = builder.response;
        this.remark = builder.remark;
        this.isCache = builder.isCache;
        this.isSuccess = builder.isSuccess;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.requestTime = builder.requestTime;
        this.contentLength = builder.contentLength;
        this.lastModified = builder.lastModified;
        this.expiration = builder.expiration;
        this.eTag = builder.eTag;
        this.responseCode = builder.responseCode;
        this.responseMessage = builder.responseMessage;
        this.responseHeaders = builder.responseHeaders;
    }

    public static class Builder {

        public int what = ExRequest.DEFAULT_WHAT;
        public byte[] data;
        public Object response;
        public Object remark;

        public boolean isCache = false;
        public boolean isSuccess;

        public long startTime;
        public long endTime;
        public long requestTime;

        public long contentLength;
        public long lastModified;
        public long expiration;
        public String eTag = "";
        public int responseCode;
        public String responseMessage = "";
        public Map<String, List<String>> responseHeaders;

        public Builder(int what) {

            this.what = what;
        }

        public Builder setReuest(ExRequest request) {

            return this;
        }

        public Builder setData(byte[] data) {

            this.data = data;

            return this;
        }

        public Builder setResponse(Object response) {

            this.response = response;

            return this;
        }

        public Builder setRemark(Object remark) {

            this.remark = remark;

            return this;
        }

        public Builder setIsCache() {

            this.isCache = true;

            return this;
        }

        public Builder setIsSuccess() {

            this.isSuccess = true;

            return this;
        }

        public Builder setStartTime(long startTime) {

            this.startTime = startTime;

            return this;
        }

        public Builder setEndTime(long endTime) {

            this.endTime = endTime;

            return this;
        }

        public Builder setRequestTime(long requestTime) {

            this.requestTime = requestTime;

            return this;
        }

        public Builder setContentLength(long contentLength) {

            this.contentLength = contentLength;

            return this;
        }

        public Builder setLastModified(long lastModified) {

            this.lastModified = lastModified;

            return this;
        }

        public Builder setExpiration(long expiration) {

            this.expiration = expiration;

            return this;
        }

        public Builder setETag(String eTag) {

            this.eTag = eTag;

            return this;
        }

        public Builder setResponseCode(int responseCode) {

            this.responseCode = responseCode;

            return this;
        }

        public Builder setResponseMessage(String responseMessage) {

            this.responseMessage = responseMessage;

            return this;
        }

        public Builder setResponseHeaders(Map<String, List<String>> responseHeaders) {

            this.responseHeaders = responseHeaders;

            return this;
        }

        public ExResponse builder() {

            return new ExResponse(this);
        }

    }

}
