/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.GitBranchType;

public class GitBranchInfo {
    private final String name;
    private final GitBranchType type;
    private final String pattern;

    GitBranchInfo(String name, GitBranchType type, String pattern) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        this.name = name;
        this.type = type;
        this.pattern = pattern;
    }

    public String getName() {
        return this.name;
    }

    public GitBranchType getType() {
        return this.type;
    }

    public boolean isSnapshot() {
        return GitBranchType.SNAPSHOT_TYPES.contains((Object)this.type);
    }

    public boolean isVersioned() {
        return GitBranchType.VERSIONED_TYPES.contains((Object)this.type);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toString() {
        return "GitBranchInfo: [name='" + this.name + '\'' + ", type='" + (Object)((Object)this.type) + '\'' + ", pattern='" + this.pattern + '\'' + ']';
    }
}

