/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.AbstractGitflowBranchMojo;
import com.e_gineering.maven.gitflowhelper.GitBranchInfo;
import com.e_gineering.maven.gitflowhelper.GitBranchType;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(requiresDependencyCollection=ResolutionScope.TEST, name="enforce-versions", defaultPhase=LifecyclePhase.VALIDATE)
public class EnforceVersionsMojo
extends AbstractGitflowBranchMojo {
    @Parameter(defaultValue="true", property="enforceNonSnapshots", required=true)
    private boolean enforceNonSnapshots;
    @Parameter(defaultValue="false", property="allowGitflowPluginSnapshot", required=true)
    private boolean allowGitflowPluginSnapshot;

    @Override
    protected void execute(GitBranchInfo branchInfo) throws MojoExecutionException, MojoFailureException {
        if (branchInfo.isVersioned()) {
            this.getLog().debug((CharSequence)("Versioned Branch: " + branchInfo));
            Matcher gitMatcher = Pattern.compile(branchInfo.getPattern()).matcher(branchInfo.getName());
            if (gitMatcher.matches()) {
                if (this.hasSnapshotInModel(this.project)) {
                    throw new MojoFailureException("The current git branch: [" + branchInfo.getName() + "] is defined as a release branch. The maven project or one of its parents is currently a snapshot version.");
                }
                if (gitMatcher.groupCount() > 0 && gitMatcher.group(gitMatcher.groupCount()) != null) {
                    this.checkReleaseTypeBranchVersion(branchInfo, gitMatcher);
                }
                if (this.enforceNonSnapshots) {
                    Set<String> snapshotDeps = this.getSnapshotDeps();
                    if (!snapshotDeps.isEmpty()) {
                        throw new MojoFailureException("The current git branch: [" + branchInfo.getName() + "] is defined as a release branch. The maven project has the following SNAPSHOT dependencies: " + snapshotDeps.toString());
                    }
                    Set<String> snapshotPluginDeps = this.getSnapshotPluginDeps();
                    if (!snapshotPluginDeps.isEmpty()) {
                        throw new MojoFailureException("The current git branch: [" + branchInfo.getName() + "] is defined as a release branch. The maven project has the following SNAPSHOT plugin dependencies: " + snapshotPluginDeps.toString());
                    }
                }
            }
        } else if (branchInfo.isSnapshot() && !ArtifactUtils.isSnapshot((String)this.project.getVersion())) {
            throw new MojoFailureException("The current git branch: [" + branchInfo.getName() + "] is detected as a SNAPSHOT-type branch, and expects a maven project version ending with -SNAPSHOT. The maven project version found was: [" + this.project.getVersion() + "]");
        }
    }

    private void checkReleaseTypeBranchVersion(GitBranchInfo branchInfo, Matcher gitMatcher) throws MojoFailureException {
        if ("equals".equals(this.releaseBranchMatchType)) {
            if ((GitBranchType.RELEASE.equals((Object)branchInfo.getType()) || GitBranchType.HOTFIX.equals((Object)branchInfo.getType())) && !gitMatcher.group(gitMatcher.groupCount()).trim().equals(this.project.getVersion().trim())) {
                throw new MojoFailureException("The current git branch: [" + branchInfo.getName() + "] expected the maven project version to be: [" + gitMatcher.group(gitMatcher.groupCount()).trim() + "], but the maven project version is: [" + this.project.getVersion() + "]");
            }
            if (GitBranchType.SUPPORT.equals((Object)branchInfo.getType()) && !this.project.getVersion().startsWith(gitMatcher.group(gitMatcher.groupCount()).trim())) {
                throw new MojoFailureException("The current git branch: [" + branchInfo.getName() + "] expected the maven project version to start with: [" + gitMatcher.group(gitMatcher.groupCount()).trim() + "], but the maven project version is: [" + this.project.getVersion() + "]");
            }
        } else if (gitMatcher.groupCount() > 0 && !GitBranchType.MASTER.equals((Object)branchInfo.getType())) {
            String releaseBranchVersion = gitMatcher.group(gitMatcher.groupCount()).trim();
            if ((GitBranchType.RELEASE.equals((Object)branchInfo.getType()) || GitBranchType.HOTFIX.equals((Object)branchInfo.getType()) || GitBranchType.SUPPORT.equals((Object)branchInfo.getType())) && !this.project.getVersion().startsWith(releaseBranchVersion)) {
                throw new MojoFailureException("The current git branch: [" + branchInfo.getName() + "] expected the maven project version to start with: [" + releaseBranchVersion + "], but the maven project version is: [" + this.project.getVersion() + "]");
            }
        }
    }

    private boolean hasSnapshotInModel(MavenProject project) {
        MavenProject parent = project.getParent();
        boolean projectIsSnapshot = ArtifactUtils.isSnapshot((String)project.getVersion());
        boolean parentIsSnapshot = parent != null && this.hasSnapshotInModel(parent);
        return projectIsSnapshot || parentIsSnapshot;
    }

    private Set<String> getSnapshotDeps() {
        HashSet<String> snapshotDeps = new HashSet<String>();
        for (Artifact dep : this.project.getArtifacts()) {
            if (!ArtifactUtils.isSnapshot((String)dep.getVersion())) continue;
            this.getLog().debug((CharSequence)("SNAPSHOT dependency found: " + dep.toString()));
            snapshotDeps.add(dep.toString());
        }
        return snapshotDeps;
    }

    private Set<String> getSnapshotPluginDeps() {
        HashSet<String> snapshotPluginDeps = new HashSet<String>();
        for (Artifact plugin : this.project.getPluginArtifacts()) {
            if (!plugin.isSnapshot()) continue;
            if (this.allowGitflowPluginSnapshot && plugin.getGroupId().equals("com.e-gineering") && plugin.getArtifactId().equals("gitflow-helper-maven-plugin")) {
                this.getLog().warn((CharSequence)"SNAPSHOT com.e-gineering:gitflow-helper-maven-plugin detected. Allowing for this build.");
                continue;
            }
            this.getLog().debug((CharSequence)("SNAPSHOT plugin dependency found: " + plugin.toString()));
            snapshotPluginDeps.add(plugin.toString());
        }
        return snapshotPluginDeps;
    }
}

