/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.AbstractGitflowBranchMojo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.utils.StringUtils;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManagerFactory;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

abstract class AbstractGitflowBasedRepositoryMojo
extends AbstractGitflowBranchMojo {
    private static final String CATALOG_HEADER = "[artifacts]";
    @Parameter(property="releaseDeploymentRepositoryId", required=true)
    String releaseDeploymentRepository;
    @Parameter(property="stageDeploymentRepositoryId", required=true)
    String stageDeploymentRepository;
    @Parameter(property="snapshotDeploymentRepositoryId", required=true)
    String snapshotDeploymentRepository;
    @Parameter(property="otherDeployBranchPattern", required=false)
    String otherDeployBranchPattern;
    @Parameter(defaultValue="+", required=true)
    String otherBranchVersionDelimiter;
    @Parameter(defaultValue="${repositorySystemSession}", required=true)
    RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File buildDirectory;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private EnhancedLocalRepositoryManagerFactory localRepositoryManagerFactory;
    @Component
    private MavenProjectHelper projectHelper;

    AbstractGitflowBasedRepositoryMojo() {
    }

    private static PrintWriter newPrintWriter(File catalog) throws FileNotFoundException {
        Objects.requireNonNull(catalog, "catalog must not be null");
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(catalog), StandardCharsets.UTF_8));
    }

    ArtifactRepository getDeploymentRepository(String id) throws MojoFailureException {
        Objects.requireNonNull(id, "A repository id must be specified.");
        Optional<ArtifactRepository> repo = this.project.getRemoteArtifactRepositories().stream().filter(r -> r.getId().equals(id)).findFirst();
        if (!repo.isPresent()) {
            throw new MojoFailureException("No Repository with id `" + id + "` is defined.");
        }
        return repo.get();
    }

    void attachArtifactCatalog() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Cataloging Artifacts for promotion & reattachment: " + this.project.getBuild().getDirectory()));
        File catalog = new File(this.buildDirectory, this.project.getArtifact().getArtifactId() + ".txt");
        if (!catalog.delete()) {
            this.getLog().debug((CharSequence)("Failed to remove catalog file: " + catalog));
        }
        if (!this.buildDirectory.mkdirs()) {
            this.getLog().debug((CharSequence)("Failed to create build directory: " + this.buildDirectory));
        }
        try (PrintWriter writer = null;){
            writer = AbstractGitflowBasedRepositoryMojo.newPrintWriter(catalog);
            writer.println(CATALOG_HEADER);
            if (this.hasCataloguableArtifacts()) {
                if (this.hasFile(this.project.getArtifact())) {
                    this.catalogArtifact(writer, this.project.getArtifact());
                } else {
                    this.getLog().info((CharSequence)"No primary artifact to catalog, cataloging attached artifacts instead.");
                }
                for (org.apache.maven.artifact.Artifact artifact : this.project.getAttachedArtifacts()) {
                    this.catalogArtifact(writer, artifact);
                }
            } else {
                this.getLog().info((CharSequence)"No artifacts were catalogued.");
            }
            this.getLog().info((CharSequence)("Attaching catalog artifact: " + catalog));
            this.projectHelper.attachArtifact(this.project, "txt", "catalog", catalog);
        }
    }

    private void catalogArtifact(PrintWriter writer, org.apache.maven.artifact.Artifact artifact) {
        String coords = this.getCoordinates(artifact);
        this.getLog().info((CharSequence)("Cataloging: " + coords));
        writer.println(coords);
    }

    void attachExistingArtifacts(@Nullable String sourceRepository, boolean disableLocal) throws MojoExecutionException, MojoFailureException {
        ArrayList<ArtifactRepository> remoteArtifactRepositories = new ArrayList<ArtifactRepository>();
        Optional<ArtifactRepository> repo = this.project.getRemoteArtifactRepositories().stream().filter(r -> r.getId().equals(sourceRepository)).findFirst();
        if (repo.isPresent()) {
            remoteArtifactRepositories.add(repo.get());
        } else {
            if (disableLocal) {
                throw new MojoExecutionException("Cannot resolve artifacts from 'null' repository if the local repository is also disabled.");
            }
            this.getLog().debug((CharSequence)"Resolving existing artifacts from local repository only.");
        }
        List remoteRepositories = RepositoryUtils.toRepos(remoteArtifactRepositories);
        ArrayList<ArtifactResult> resolvedArtifacts = new ArrayList<ArtifactResult>();
        DefaultRepositorySystemSession tempSession = new DefaultRepositorySystemSession(this.repositorySystemSession);
        tempSession.setUpdatePolicy("always");
        File tempRepo = null;
        if (disableLocal) {
            this.getLog().info((CharSequence)("Disabling local repository @ " + tempSession.getLocalRepository().getBasedir()));
            try {
                tempRepo = Files.createTempDirectory("gitflow-helper-maven-plugin-repo", new FileAttribute[0]).toFile();
                this.getLog().info((CharSequence)("Using temporary local repository @ " + tempRepo.getAbsolutePath()));
                tempSession.setLocalRepositoryManager(this.localRepositoryManagerFactory.newInstance((RepositorySystemSession)tempSession, new LocalRepository(tempRepo)));
            }
            catch (Exception ex) {
                this.getLog().warn((CharSequence)"Failed to disable local repository path.", (Throwable)ex);
            }
        }
        tempSession.setReadOnly();
        ArrayList<ArtifactRequest> requiredArtifacts = new ArrayList<ArtifactRequest>();
        BufferedReader reader = null;
        try {
            DefaultArtifact artifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), "catalog", "txt", this.project.getVersion());
            ArtifactRequest request = new ArtifactRequest((Artifact)artifact, remoteRepositories, null);
            ArtifactResult catalogResult = this.repositorySystem.resolveArtifact((RepositorySystemSession)tempSession, request);
            resolvedArtifacts.add(catalogResult);
            if (catalogResult.isResolved()) {
                String coords;
                FileInputStream fis = new FileInputStream(catalogResult.getArtifact().getFile());
                InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
                reader = new BufferedReader(isr);
                boolean firstLine = true;
                while ((coords = reader.readLine()) != null) {
                    if (!((coords = coords.trim()).isEmpty() || firstLine && CATALOG_HEADER.equals(coords))) {
                        requiredArtifacts.add(new ArtifactRequest((Artifact)new DefaultArtifact(coords), remoteRepositories, null));
                    }
                    firstLine = false;
                }
            }
        }
        catch (ArtifactResolutionException are) {
            throw new MojoExecutionException("Could not locate artifact catalog in remote repository.", (Exception)((Object)are));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not read artifact catalog", (Exception)ioe);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            resolvedArtifacts.addAll(this.repositorySystem.resolveArtifacts((RepositorySystemSession)tempSession, requiredArtifacts));
        }
        catch (ArtifactResolutionException are) {
            throw new MojoExecutionException("Failed to resolve the required project files from repository: " + sourceRepository, (Exception)((Object)are));
        }
        String projectArtifactCoordinates = this.getCoordinates(this.project.getArtifact());
        this.getLog().debug((CharSequence)("Current Project Coordinates: " + projectArtifactCoordinates));
        for (ArtifactResult artifactResult : resolvedArtifacts) {
            try {
                FileUtils.copyFileToDirectory((File)artifactResult.getArtifact().getFile(), (File)this.buildDirectory);
                artifactResult.setArtifact(artifactResult.getArtifact().setFile(new File(this.buildDirectory, artifactResult.getArtifact().getFile().getName())));
                if (this.getCoordinates(artifactResult).equals(projectArtifactCoordinates)) {
                    this.getLog().debug((CharSequence)("    Setting primary artifact: " + artifactResult.getArtifact().getFile()));
                    this.project.getArtifact().setFile(artifactResult.getArtifact().getFile());
                    continue;
                }
                this.getLog().debug((CharSequence)("    Attaching artifact: " + this.getCoordinates(artifactResult) + " " + artifactResult.getArtifact().getFile()));
                this.projectHelper.attachArtifact(this.project, artifactResult.getArtifact().getExtension(), artifactResult.getArtifact().getClassifier(), artifactResult.getArtifact().getFile());
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Failed to copy resolved artifact to target directory.", (Exception)ioe);
            }
        }
        if (disableLocal && tempRepo != null) {
            try {
                FileUtils.deleteDirectory((File)tempRepo);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Failed to cleanup temporary repository directory: " + tempRepo));
            }
        }
    }

    private boolean hasCataloguableArtifacts() {
        return this.hasFile(this.project.getArtifact()) || !this.project.getAttachedArtifacts().isEmpty();
    }

    private boolean hasFile(@Nullable org.apache.maven.artifact.Artifact artifact) {
        return artifact != null && this.project.getArtifact().getFile() != null && this.project.getArtifact().getFile().exists() && this.project.getArtifact().getFile().isFile();
    }

    private String getCoordinates(ArtifactResult artifactResult) {
        return this.getCoordinates(AbstractGitflowBasedRepositoryMojo.emptyToNull(artifactResult.getArtifact().getGroupId()), AbstractGitflowBasedRepositoryMojo.emptyToNull(artifactResult.getArtifact().getArtifactId()), AbstractGitflowBasedRepositoryMojo.emptyToNull(artifactResult.getArtifact().getBaseVersion()), AbstractGitflowBasedRepositoryMojo.emptyToNull(artifactResult.getArtifact().getExtension()), AbstractGitflowBasedRepositoryMojo.emptyToNull(artifactResult.getArtifact().getClassifier()));
    }

    private static String emptyToNull(String s) {
        return StringUtils.isBlank((String)s) ? null : s;
    }

    private String getCoordinates(org.apache.maven.artifact.Artifact artifact) {
        this.getLog().debug((CharSequence)("   Encoding Coordinates For: " + artifact));
        String extension = artifact.getArtifactHandler().getExtension();
        return this.getCoordinates(artifact.getGroupId(), artifact.getArtifactId(), this.project.getVersion(), extension, artifact.hasClassifier() ? artifact.getClassifier() : null);
    }

    private String getCoordinates(String groupId, String artifactId, String version, @Nullable String extension, @Nullable String classifier) {
        Objects.requireNonNull(groupId, "groupId must not be null");
        Objects.requireNonNull(artifactId, "artifactId must not be null");
        Objects.requireNonNull(version, "version must not be null");
        StringBuilder result = new StringBuilder();
        for (String s : new String[]{groupId, artifactId, extension, classifier, version}) {
            if (s == null) continue;
            if (result.length() > 0) {
                result.append(":");
            }
            result.append(s);
        }
        return result.toString();
    }
}

