/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory.replay;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InsertBeforeInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionReplayTableReloadTransformerFactory
implements TransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"SessionReplayTableReloadTransformerFactory");
    private static final String ABS_LIST_VIEW = "android.widget.AbsListView";
    private static final String RECYCLER_VIEW = "androidx.recyclerview.widget.RecyclerView";

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> methodSensors = new ArrayList<SensorGroup<MethodSensor>>();
        methodSensors.add(this.getGenerateRecyclerViewTableReloadSensor());
        return new DefaultSubTransformer("SessionReplayTableReloadTransformer", Collections.singletonList(this.generateAbsListSensors(classResolver)), methodSensors, classResolver);
    }

    private SensorGroup<InstructionSensor> generateAbsListSensors(ClassResolver classResolver) {
        InsertBeforeInstructionSensor sensorListSetAdapter = new InsertBeforeInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(ABS_LIST_VIEW), "setAdapter", "(Landroid/widget/ListAdapter;)V"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.InstrumentorApi"), "setAdapter", "(Landroid/view/View;Landroid/widget/ListAdapter;)V"));
        return new SensorGroupImpl<InstructionSensor>(classResolver.resolveClass(ABS_LIST_VIEW), sensorListSetAdapter);
    }

    private SensorGroup<MethodSensor> getGenerateRecyclerViewTableReloadSensor() {
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> RECYCLER_VIEW.equals(otherClassInfo.getName()), new MethodSensorImpl(new MethodInfo("setAdapter", "(Landroidx/recyclerview/widget/RecyclerView$Adapter;)V", 1, null, new ArrayList<String>()), new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.recyclerview.callback.RecyclerViewCallback"), "setAdapter", "(Landroidx/recyclerview/widget/RecyclerView;Landroidx/recyclerview/widget/RecyclerView$Adapter;)V"), ParameterInstructionProvider.withThisAndAllParameters("(Landroidx/recyclerview/widget/RecyclerView$Adapter;)V"))));
    }
}

