/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InsertAfterInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.ReplaceInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;

public class HttpUrlConnectionTransformerFactory
implements TransformerFactory {
    private static final String HTTP_URL_CONNECTION = "java.net.HttpURLConnection";
    private static final String URL_CONNECTION = "java.net.URLConnection";
    private static final String URL = "java.net.URL";
    private static final String DYNATRACE_INSTRUMENTATION_CALLBACK = Utils.dotToSlash("com.dynatrace.android.callback.Callback");

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<InstructionSensor>> instructionSensors = new ArrayList<SensorGroup<InstructionSensor>>();
        instructionSensors.add(this.generateHttpUrlConnectionSensors(classResolver));
        instructionSensors.add(this.generateUrlConnectionSensors());
        instructionSensors.add(this.generateUrlSensors());
        return new DefaultSubTransformer("HttpUrlConnectionTransformer", instructionSensors, new ArrayList<SensorGroup<MethodSensor>>(), classResolver);
    }

    private SensorGroup<InstructionSensor> generateHttpUrlConnectionSensors(ClassResolver classResolver) {
        ArrayList<InstructionSensor> sensors = new ArrayList<InstructionSensor>();
        sensors.addAll(this.generateTaggingSensors());
        sensors.addAll(this.generateMonitoringSensorsHttpUrlConnection());
        sensors.add(new InsertAfterInstructionSensor("<init>", instructions -> {
            instructions.add((AbstractInsnNode)new InsnNode(89));
            instructions.add((AbstractInsnNode)Utils.generateMethodInstructionNode(MethodInstruction.createStaticMethodInstruction(DYNATRACE_INSTRUMENTATION_CALLBACK, "newInstance", "(Ljava/net/HttpURLConnection;)V")));
        }));
        return new SensorGroupImpl<InstructionSensor>(classResolver.resolveClass(HTTP_URL_CONNECTION), (List<InstructionSensor>)sensors);
    }

    private SensorGroup<InstructionSensor> generateUrlConnectionSensors() {
        ArrayList<InstructionSensor> sensors = new ArrayList<InstructionSensor>();
        sensors.addAll(this.generateTaggingSensors());
        sensors.addAll(this.generateMonitoringSensorsUrlConnection());
        return new SensorGroupImpl<InstructionSensor>(otherClassInfo -> URL_CONNECTION.equals(otherClassInfo.getName()), (List<InstructionSensor>)sensors);
    }

    private List<InstructionSensor> generateMonitoringSensorsHttpUrlConnection() {
        String methodOwner = Utils.dotToSlash(HTTP_URL_CONNECTION);
        return Arrays.asList(this.buildReplaceInstructionSensor(methodOwner, "connect", "()V", "(Ljava/net/HttpURLConnection;)V"), this.buildReplaceInstructionSensor(methodOwner, "getResponseCode", "()I", "(Ljava/net/HttpURLConnection;)I"), this.buildReplaceInstructionSensor(methodOwner, "getResponseMessage", "()Ljava/lang/String;", "(Ljava/net/HttpURLConnection;)Ljava/lang/String;"), this.buildReplaceInstructionSensor(methodOwner, "getInputStream", "()Ljava/io/InputStream;", "(Ljava/net/HttpURLConnection;)Ljava/io/InputStream;"), this.buildReplaceInstructionSensor(methodOwner, "getErrorStream", "()Ljava/io/InputStream;", "(Ljava/net/HttpURLConnection;)Ljava/io/InputStream;"), this.buildReplaceInstructionSensor(methodOwner, "getOutputStream", "()Ljava/io/OutputStream;", "(Ljava/net/HttpURLConnection;)Ljava/io/OutputStream;"));
    }

    private List<InstructionSensor> generateMonitoringSensorsUrlConnection() {
        String methodOwner = Utils.dotToSlash(URL_CONNECTION);
        return Arrays.asList(this.buildReplaceInstructionSensor(methodOwner, "connect", "()V", "(Ljava/net/URLConnection;)V"), this.buildReplaceInstructionSensor(methodOwner, "getInputStream", "()Ljava/io/InputStream;", "(Ljava/net/URLConnection;)Ljava/io/InputStream;"), this.buildReplaceInstructionSensor(methodOwner, "getOutputStream", "()Ljava/io/OutputStream;", "(Ljava/net/URLConnection;)Ljava/io/OutputStream;"));
    }

    private List<InstructionSensor> generateTaggingSensors() {
        String methodOwner = Utils.dotToSlash(URL_CONNECTION);
        return Arrays.asList(this.buildReplaceInstructionSensor(methodOwner, "getContentLength", "()I", "(Ljava/net/URLConnection;)I"), this.buildReplaceInstructionSensor(methodOwner, "getContentLengthLong", "()J", "(Ljava/net/URLConnection;)J"), this.buildReplaceInstructionSensor(methodOwner, "getContentType", "()Ljava/lang/String;", "(Ljava/net/URLConnection;)Ljava/lang/String;"), this.buildReplaceInstructionSensor(methodOwner, "getContentEncoding", "()Ljava/lang/String;", "(Ljava/net/URLConnection;)Ljava/lang/String;"), this.buildReplaceInstructionSensor(methodOwner, "getExpiration", "()J", "(Ljava/net/URLConnection;)J"), this.buildReplaceInstructionSensor(methodOwner, "getDate", "()J", "(Ljava/net/URLConnection;)J"), this.buildReplaceInstructionSensor(methodOwner, "getLastModified", "()J", "(Ljava/net/URLConnection;)J"), this.buildReplaceInstructionSensor(methodOwner, "getHeaderField", "(Ljava/lang/String;)Ljava/lang/String;", "(Ljava/net/URLConnection;Ljava/lang/String;)Ljava/lang/String;"), this.buildReplaceInstructionSensor(methodOwner, "getHeaderFields", "()Ljava/util/Map;", "(Ljava/net/URLConnection;)Ljava/util/Map;"), this.buildReplaceInstructionSensor(methodOwner, "getContent", "()Ljava/lang/Object;", "(Ljava/net/URLConnection;)Ljava/lang/Object;"), this.buildReplaceInstructionSensor(methodOwner, "getContent", "([Ljava/lang/Class;)Ljava/lang/Object;", "(Ljava/net/URLConnection;[Ljava/lang/Class;)Ljava/lang/Object;"), this.buildReplaceInstructionSensor(methodOwner, "getHeaderField", "(I)Ljava/lang/String;", "(Ljava/net/URLConnection;I)Ljava/lang/String;"), this.buildReplaceInstructionSensor(methodOwner, "getHeaderFieldKey", "(I)Ljava/lang/String;", "(Ljava/net/URLConnection;I)Ljava/lang/String;"), this.buildReplaceInstructionSensor(methodOwner, "getHeaderFieldInt", "(Ljava/lang/String;I)I", "(Ljava/net/URLConnection;Ljava/lang/String;I)I"), this.buildReplaceInstructionSensor(methodOwner, "getHeaderFieldLong", "(Ljava/lang/String;J)J", "(Ljava/net/URLConnection;Ljava/lang/String;J)J"), this.buildReplaceInstructionSensor(methodOwner, "getHeaderFieldDate", "(Ljava/lang/String;J)J", "(Ljava/net/URLConnection;Ljava/lang/String;J)J"));
    }

    private InstructionSensor buildReplaceInstructionSensor(String methodOwner, String methodName, String originalMethodDescriptor, String instrumentedMethodDescriptor) {
        return new ReplaceInstructionSensor(MethodInstruction.createPublicMethodInstruction(methodOwner, methodName, originalMethodDescriptor), MethodInstruction.createStaticMethodInstruction(DYNATRACE_INSTRUMENTATION_CALLBACK, methodName, instrumentedMethodDescriptor));
    }

    private SensorGroup<InstructionSensor> generateUrlSensors() {
        TransformerUtils.InstructionFactory openConnectionFactory = instructions -> {
            instructions.add((AbstractInsnNode)new InsnNode(89));
            instructions.add((AbstractInsnNode)Utils.generateMethodInstructionNode(MethodInstruction.createStaticMethodInstruction(DYNATRACE_INSTRUMENTATION_CALLBACK, "openConnection", "(Ljava/net/URLConnection;)V")));
        };
        return new SensorGroupImpl<InstructionSensor>(otherClassInfo -> URL.equals(otherClassInfo.getName()), new InsertAfterInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(URL), "openConnection", "()Ljava/net/URLConnection;"), openConnectionFactory), new InsertAfterInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(URL), "openConnection", "(Ljava/net/Proxy;)Ljava/net/URLConnection;"), openConnectionFactory));
    }
}

