/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.method;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.method.ExitMethodTransformation;
import com.dynatrace.android.instrumentation.sensor.method.MethodFilter;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import org.objectweb.asm.tree.MethodNode;

public class MethodSensorImpl
implements MethodSensor {
    private final MethodFilter filter;
    private final MethodTransformation[] transformations;

    public MethodSensorImpl(MethodInfo methodInfo, MethodTransformation ... transformations) {
        this((ClassInfo classInfo, String methodName, String methodDesc, boolean isLambda) -> methodName.equals(methodInfo.getMethodName()) && methodDesc.equals(methodInfo.getMethodDescriptor()), transformations);
    }

    public MethodSensorImpl(MethodFilter filter, MethodTransformation ... transformations) {
        this.filter = filter;
        this.transformations = transformations;
    }

    public static MethodTransformation[] generateDefaultMethodTransformer(MethodInstruction startSensorMethod, MethodInstruction exitSensorMethod) {
        MethodTransformation[] methodTransformations = new MethodTransformation[]{new ExitMethodTransformation(exitSensorMethod, null), new StartMethodTransformation(startSensorMethod, ParameterInstructionProvider.withAllParameters(startSensorMethod.getMethodDescriptor()))};
        return methodTransformations;
    }

    @Override
    public boolean matchMethod(ClassInfo classInfo, String methodName, String desc, boolean isLambda) {
        return this.filter.matchMethod(classInfo, methodName, desc, isLambda);
    }

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        for (MethodTransformation transformation : this.transformations) {
            transformation.transformMethod(methodNode, startParameterIndex);
        }
    }
}

