/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay.transformation.material;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeMaterial;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeMaterialVersion;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUi;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ComposeReplayBottomDrawerTransformation
implements MethodTransformation {
    private final String instrumentedClass;
    private final String drawerCallback;

    public ComposeReplayBottomDrawerTransformation(ClassResolver classResolver) {
        this.instrumentedClass = "androidx/compose/material/DrawerKt$" + this.getBottomDrawerVersion(classResolver);
        this.drawerCallback = ComposeUi.getVersionPackage(classResolver) + "/callback/WrappingBottomDrawerComposeCallback";
    }

    private String getBottomDrawerVersion(ClassResolver classResolver) {
        ComposeMaterialVersion composeMaterialVersion = ComposeMaterial.getVersion(classResolver);
        if (composeMaterialVersion == ComposeMaterialVersion.V1_4 || composeMaterialVersion == ComposeMaterialVersion.V1_7) {
            return "BottomDrawer$1";
        }
        return "BottomDrawer$2";
    }

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        InsnList instructions = methodNode.instructions;
        for (AbstractInsnNode insnNode : instructions) {
            InsnList list = new InsnList();
            if (insnNode instanceof TypeInsnNode && insnNode.getOpcode() == 187 && ((TypeInsnNode)insnNode).desc.equals(this.instrumentedClass)) {
                list.add((AbstractInsnNode)new TypeInsnNode(187, this.drawerCallback));
                list.add((AbstractInsnNode)new InsnNode(89));
                instructions.insertBefore(insnNode, list);
            }
            if (!(insnNode instanceof MethodInsnNode) || insnNode.getOpcode() != 183 || !((MethodInsnNode)insnNode).name.equals("<init>") || !((MethodInsnNode)insnNode).owner.equals(this.instrumentedClass)) continue;
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new MethodInsnNode(183, this.drawerCallback, "<init>", "(Lkotlin/jvm/functions/Function3;Landroidx/compose/material/BottomDrawerState;)V"));
            instructions.insert(insnNode, list);
        }
    }
}

