/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay.sensor;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUi;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SessionReplayLayoutNodeSensor
implements SensorGroup<MethodSensor> {
    private static final String LAYOUT_NODE_SOURCE = "androidx.compose.ui.node.LayoutNode";
    private static final String DISPATCH_METHOD_NAME = "dispatchOnPositionedCallbacks$ui_release";
    private static final String DISPATCH_METHOD_DESCRIPTION = "()V";
    private final String resolvedInstrumentorApi;

    public SessionReplayLayoutNodeSensor(ClassResolver classResolver) {
        this.resolvedInstrumentorApi = ComposeUi.getInstrumentorApi(classResolver);
    }

    @Override
    public boolean matchClass(ClassInfo classInfo) {
        return LAYOUT_NODE_SOURCE.equals(classInfo.getName());
    }

    @Override
    public List<MethodSensor> getSensors() {
        return List.of(this.generateDispatchOnPositionedCallbacksSensor());
    }

    private MethodSensor generateDispatchOnPositionedCallbacksSensor() {
        MethodInfo methodInfo = new MethodInfo(DISPATCH_METHOD_NAME, DISPATCH_METHOD_DESCRIPTION, 17, null, new ArrayList<String>());
        MethodTransformation onSizeChangedNodeTransformation = (methodNode, startParameterIndex) -> {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new MethodInsnNode(184, Utils.dotToSlash(this.resolvedInstrumentorApi), "dispatchOnPositionedCallbacks", "(Landroidx/compose/ui/layout/LayoutInfo;)V", false));
            ArrayList<AbstractInsnNode> returnInstructions = new ArrayList<AbstractInsnNode>();
            for (AbstractInsnNode instruction : methodNode.instructions) {
                if (!TransformerUtils.isReturnInstruction(instruction)) continue;
                returnInstructions.add(instruction);
            }
            methodNode.instructions.insertBefore((AbstractInsnNode)returnInstructions.get(returnInstructions.size() - 1), list);
        };
        return new MethodSensorImpl(methodInfo, onSizeChangedNodeTransformation);
    }
}

