/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.agent;

import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.util.Utils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class AutoStartTransformation
implements MethodTransformation {
    private static final MethodInstruction BUILD_CONFIGURATION = MethodInstruction.createPublicMethodInstruction("com/dynatrace/android/agent/conf/ConfigurationBuilder", "buildConfiguration", "()Lcom/dynatrace/android/agent/conf/Configuration;");
    private static final MethodInstruction DYNATRACE_CONFIG_BUILDER_CTOR = MethodInstruction.createConstructorInstruction("com/dynatrace/android/agent/conf/DynatraceConfigurationBuilder", "(Ljava/lang/String;Ljava/lang/String;)V");
    private final MethodInstruction builderConstructor;
    private final BuilderConfiguration builderConfig;

    public AutoStartTransformation(BuilderConfiguration builderConfig) {
        this.builderConfig = builderConfig;
        this.builderConstructor = DYNATRACE_CONFIG_BUILDER_CTOR;
    }

    private InsnList getConfigurationInsn() {
        InsnList instr = new InsnList();
        instr.add((AbstractInsnNode)new TypeInsnNode(187, this.builderConstructor.getClassName()));
        instr.add((AbstractInsnNode)new InsnNode(89));
        Utils.pushValueToStack(instr, this.builderConfig.applicationId);
        Utils.pushValueToStack(instr, this.builderConfig.beaconUrl);
        instr.add((AbstractInsnNode)Utils.generateMethodInstructionNode(this.builderConstructor));
        instr.add((AbstractInsnNode)Utils.generateMethodInstructionNode(BUILD_CONFIGURATION));
        instr.add((AbstractInsnNode)new InsnNode(176));
        return instr;
    }

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        methodNode.instructions.clear();
        methodNode.instructions.add(this.getConfigurationInsn());
    }

    public static class BuilderConfiguration {
        public final boolean isSaas;
        public final String applicationId;
        public final String beaconUrl;

        public BuilderConfiguration(String applicationId, String beaconUrl, boolean isSaas) {
            this.isSaas = isSaas;
            this.applicationId = applicationId;
            this.beaconUrl = beaconUrl;
        }
    }
}

