/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation;

import com.dynatrace.android.instrumentation.ClassInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ClassLoaderClassInfo
implements ClassInfo {
    private final ClassLoader classLoader;
    private final Class<?> clazz;
    private List<String> interfaces;
    private List<Class<?>> superClasses;

    public ClassLoaderClassInfo(Class<?> clazz, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.clazz = clazz;
    }

    static List<Class<?>> gatherSuperClasses(Class<?> clazz) {
        ArrayList superclasses = new ArrayList();
        if (clazz.isInterface()) {
            superclasses.add(Object.class);
            return superclasses;
        }
        for (Class<?> superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            superclasses.add(superclass);
        }
        return superclasses;
    }

    static Set<String> gatherInterfaces(Class<?>[] interfaces) {
        if (interfaces.length == 0) {
            return new HashSet<String>();
        }
        HashSet<String> stringInterfaces = new HashSet<String>();
        for (Class<?> ifClass : interfaces) {
            stringInterfaces.add(ifClass.getName());
            stringInterfaces.addAll(ClassLoaderClassInfo.gatherInterfaces(ifClass.getInterfaces()));
        }
        return stringInterfaces;
    }

    private List<Class<?>> lazyListOfSuperClasses() {
        if (this.superClasses == null) {
            this.superClasses = ClassLoaderClassInfo.gatherSuperClasses(this.clazz);
        }
        return this.superClasses;
    }

    private List<String> lazyListOfInterfaces() {
        if (this.interfaces == null) {
            Set<String> uniqueInterfaces = ClassLoaderClassInfo.gatherInterfaces(this.clazz.getInterfaces());
            for (Class<?> superClass : this.lazyListOfSuperClasses()) {
                uniqueInterfaces.addAll(ClassLoaderClassInfo.gatherInterfaces(superClass.getInterfaces()));
            }
            this.interfaces = new ArrayList<String>(uniqueInterfaces);
        }
        return this.interfaces;
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    @Override
    public boolean isAssignableFrom(ClassInfo otherClass) {
        if (!otherClass.isComplete()) {
            return this.clazz.getName().equals(otherClass.getName());
        }
        try {
            return this.clazz.isAssignableFrom(Class.forName(otherClass.getName(), false, this.classLoader));
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public List<String> getSuperClasses() {
        return this.lazyListOfSuperClasses().stream().map(Class::getName).collect(Collectors.toList());
    }

    @Override
    public List<String> getInterfaces() {
        return this.lazyListOfInterfaces();
    }
}

