/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.instrumentation;

import com.android.build.api.instrumentation.ClassData;
import com.dynatrace.android.instrumentation.ClassInfo;
import java.util.ArrayList;
import java.util.List;

public class ClassContextClassInfo
implements ClassInfo {
    private final String className;
    private final List<String> superClasses;
    private final List<String> interfaces;
    private final boolean isResolved;

    public ClassContextClassInfo(ClassData classData) {
        this(classData.getClassName(), new ArrayList<String>(classData.getSuperClasses()), new ArrayList<String>(classData.getInterfaces()), true);
    }

    public ClassContextClassInfo(String className, List<String> superClasses, List<String> interfaces, boolean isResolved) {
        this.className = className;
        this.superClasses = superClasses;
        this.interfaces = interfaces;
        this.isResolved = isResolved;
    }

    @Override
    public String getName() {
        return this.className;
    }

    @Override
    public List<String> getSuperClasses() {
        return this.superClasses;
    }

    @Override
    public List<String> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public boolean isAssignableFrom(ClassInfo otherClassInfo) {
        if (otherClassInfo == null) {
            return false;
        }
        return this.className.equals(otherClassInfo.getName()) || otherClassInfo.getSuperClasses().contains(this.className) || otherClassInfo.getInterfaces().contains(this.className);
    }

    @Override
    public boolean isComplete() {
        return this.isResolved;
    }
}

