/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay.transformation.material3;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeMaterial3;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeMaterial3Version;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUi;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ComposeReplayCheckboxTransformation
implements MethodTransformation {
    private final String instrumentedClassInstruction;
    private final String checkboxCallback;
    private final String composePackage;
    private final ComposeMaterial3Version composeMaterial3Version;

    public ComposeReplayCheckboxTransformation(ClassResolver classResolver) {
        this.composeMaterial3Version = ComposeMaterial3.getVersion(classResolver);
        this.instrumentedClassInstruction = this.getInstrumentedClassInstruction();
        String composePackage = ComposeUi.getVersionPackage(classResolver);
        this.checkboxCallback = composePackage + "/callback/WrappingCheckboxComposeCallback";
        this.composePackage = composePackage;
    }

    private String getInstrumentedClassInstruction() {
        if (this.composeMaterial3Version == ComposeMaterial3Version.V1_3 || this.composeMaterial3Version == ComposeMaterial3Version.V1_4) {
            return "androidx/compose/material3/CheckboxKt$Checkbox$1$1";
        }
        return "androidx/compose/material3/CheckboxKt$Checkbox$2$1";
    }

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        InsnList instructions = methodNode.instructions;
        for (AbstractInsnNode insnNode : instructions) {
            InsnList list = new InsnList();
            if (insnNode instanceof TypeInsnNode && insnNode.getOpcode() == 187 && ((TypeInsnNode)insnNode).desc.equals(this.instrumentedClassInstruction)) {
                list.add((AbstractInsnNode)new TypeInsnNode(187, this.checkboxCallback));
                list.add((AbstractInsnNode)new InsnNode(89));
                instructions.insertBefore(insnNode, list);
            }
            if (!(insnNode instanceof MethodInsnNode) || insnNode.getOpcode() != 183 || !((MethodInsnNode)insnNode).name.equals("<init>") || !((MethodInsnNode)insnNode).owner.equals(this.instrumentedClassInstruction)) continue;
            this.addCustomModifier(list);
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(21, 0));
            list.add((AbstractInsnNode)new MethodInsnNode(183, this.checkboxCallback, "<init>", "(Lkotlin/jvm/functions/Function0;Landroidx/compose/ui/Modifier;Z)V"));
            instructions.insert(insnNode, list);
        }
    }

    private void addCustomModifier(InsnList list) {
        list.add((AbstractInsnNode)new VarInsnNode(25, 2));
        String dtCompoundModifier = this.composePackage + "/model/DTCompoundModifier";
        list.add((AbstractInsnNode)new TypeInsnNode(187, dtCompoundModifier));
        list.add((AbstractInsnNode)new InsnNode(89));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)1));
        if (this.composeMaterial3Version == ComposeMaterial3Version.V1_4) {
            list.add((AbstractInsnNode)new FieldInsnNode(178, "androidx/compose/material3/CheckboxKt", "SnapAnimationDelay", "I"));
        } else {
            list.add((AbstractInsnNode)new FieldInsnNode(178, "androidx/compose/material3/CheckboxKt", "CheckAnimationDuration", "I"));
        }
        list.add((AbstractInsnNode)new MethodInsnNode(183, dtCompoundModifier, "<init>", "(II)V", false));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "androidx/compose/ui/Modifier", "then", "(Landroidx/compose/ui/Modifier;)Landroidx/compose/ui/Modifier;", true));
        list.add((AbstractInsnNode)new VarInsnNode(58, 2));
    }
}

