/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.protocols.mobile.sessionreplay.tags;

import com.dynatrace.protocols.mobile.sessionreplay.BeaconDataType;
import com.dynatrace.protocols.mobile.sessionreplay.ReasonTag;
import com.dynatrace.protocols.mobile.sessionreplay.VisitStoreType;
import com.dynatrace.protocols.mobile.sessionreplay.exceptions.CannotSplitSelfMonitoringBeaconsException;
import com.dynatrace.protocols.mobile.sessionreplay.exceptions.InvalidSerializationDataException;
import com.dynatrace.protocols.mobile.sessionreplay.exceptions.InvalidTypeException;
import com.dynatrace.protocols.mobile.sessionreplay.tags.Tags;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class TaggedBeaconBuilder {
    public static final int TAG_SIZE = 2;
    private static final short PROTOCOL_VERSION = 5;
    private String visitorId;
    private String visitId;
    private Long startTime;
    private Long endTime;
    private BeaconDataType type;
    private int maxSizeInB = -1;
    private String json = null;
    private String imageId = null;
    private ReasonTag reason = null;
    private byte[] image = null;
    private short dataVersion = 0;
    private String fullSessionMetrics = null;

    public TaggedBeaconBuilder withVisitorId(String visitorId) {
        this.visitorId = visitorId;
        return this;
    }

    public TaggedBeaconBuilder withVisitId(String visitId) {
        this.visitId = visitId;
        return this;
    }

    public TaggedBeaconBuilder withEndTime(long endTime) {
        this.endTime = endTime;
        return this;
    }

    public TaggedBeaconBuilder withStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public TaggedBeaconBuilder withType(BeaconDataType type) {
        this.type = type;
        return this;
    }

    public TaggedBeaconBuilder withJson(String json) {
        this.json = json;
        return this;
    }

    public TaggedBeaconBuilder withImage(byte[] image) {
        this.image = image;
        return this;
    }

    public TaggedBeaconBuilder withImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    public TaggedBeaconBuilder withReason(ReasonTag reason) {
        this.reason = reason;
        return this;
    }

    public TaggedBeaconBuilder withMaxBeaconSizeInKb(int maxSizeInKb) {
        this.maxSizeInB = maxSizeInKb * 1024;
        return this;
    }

    public TaggedBeaconBuilder withMaxBeaconSizeInB(int maxSizeInB) {
        this.maxSizeInB = maxSizeInB;
        return this;
    }

    public TaggedBeaconBuilder withDataVersion(short dataVersion) {
        this.dataVersion = dataVersion;
        return this;
    }

    public TaggedBeaconBuilder withFullSessionMetrics(String fullSessionMetrics) {
        this.fullSessionMetrics = fullSessionMetrics;
        return this;
    }

    public List<byte[]> build() throws InvalidSerializationDataException, CannotSplitSelfMonitoringBeaconsException, InvalidTypeException {
        this.validatePreconditions();
        switch (this.type) {
            case IMAGE: 
            case JSON: 
            case REASON: {
                return this.buildReplayBeacon();
            }
            case SELF_MONITORING: {
                return this.buildSelfMonitoringBeacon();
            }
        }
        throw new InvalidTypeException("Type should be Valid");
    }

    private List<byte[]> buildSelfMonitoringBeacon() throws CannotSplitSelfMonitoringBeaconsException, InvalidSerializationDataException {
        String beaconId = UUID.randomUUID().toString();
        byte[] beacon = this.createBeacon(this.getDataToBeSent(), beaconId);
        if (this.maxSizeInB > 0 && beacon.length > this.maxSizeInB) {
            throw new CannotSplitSelfMonitoringBeaconsException();
        }
        return Collections.singletonList(beacon);
    }

    private List<byte[]> buildReplayBeacon() throws InvalidSerializationDataException {
        byte[] visitorBytes = this.visitorId.getBytes();
        byte[] visitBytes = this.visitId.getBytes();
        ArrayList<byte[]> beacons = new ArrayList<byte[]>();
        byte[] data = this.getDataToBeSent();
        String beaconId = UUID.randomUUID().toString();
        int headerSize = 2 + Tags.PROTOCOL.getSize() + 2 + 4 + visitorBytes.length + 2 + 4 + visitBytes.length + 2 + Tags.TYPE.getSize() + 2 + Tags.VISIT_STORE.getSize() + 2 + Tags.START_TIME.getSize() + 2 + Tags.END_TIME.getSize() + 2 + Tags.SEQUENCE_NUMBER.getSize() + 2 + Tags.TOTAL.getSize() + 2 + 4 + beaconId.length() + 2 + Tags.DATA_VERSION.getSize() + 2 + 4;
        if (this.type == BeaconDataType.IMAGE) {
            byte[] imageIdBytes = this.imageId.getBytes();
            headerSize += 6 + imageIdBytes.length;
        }
        if (this.maxSizeInB > 0 && headerSize + data.length > this.maxSizeInB) {
            int maxDataSize = this.maxSizeInB - headerSize;
            if (maxDataSize <= 0) {
                throw new InvalidSerializationDataException("Max beacon size less or equal to headers size");
            }
            int from = 0;
            int chunks = new BigDecimal(data.length).divide(new BigDecimal(maxDataSize), RoundingMode.UP).intValue();
            for (int i = 0; i < chunks; ++i) {
                int to = Math.min(from + maxDataSize, data.length);
                byte[] chunk = Arrays.copyOfRange(data, from, to);
                beacons.add(this.createBeacon(chunk, beaconId, i + 1, chunks));
                from += maxDataSize;
            }
        } else {
            beacons.add(this.createBeacon(data, beaconId));
        }
        return beacons;
    }

    private byte[] createBeacon(byte[] data, String beaconId) throws InvalidSerializationDataException {
        return this.createBeacon(data, beaconId, -1, -1);
    }

    private byte[] createBeacon(byte[] data, String beaconId, Integer sequenceNumber, Integer totalBeacons) throws InvalidSerializationDataException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.addV2Tags(outputStream, data, beaconId, sequenceNumber, totalBeacons);
        this.addV3Tags(outputStream);
        this.addV4Tags(outputStream);
        this.addV5Tags(outputStream, data);
        return outputStream.toByteArray();
    }

    private void addTag(ByteArrayOutputStream outputStream, Tags tag) throws IOException {
        outputStream.write(ByteBuffer.allocate(2).putShort(tag.getIdentifier()).array());
    }

    private void addSizedData(ByteArrayOutputStream outputStream, Tags tag, byte[] data) throws IOException {
        this.addTag(outputStream, tag);
        outputStream.write(ByteBuffer.allocate(4).putInt(data.length).array());
        outputStream.write(data);
    }

    private void addLong(ByteArrayOutputStream outputStream, long value) throws IOException {
        outputStream.write(ByteBuffer.allocate(8).putLong(value).array());
    }

    private void addInt(ByteArrayOutputStream outputStream, int value) throws IOException {
        outputStream.write(ByteBuffer.allocate(4).putInt(value).array());
    }

    private void addShort(ByteArrayOutputStream outputStream, short value) throws IOException {
        outputStream.write(ByteBuffer.allocate(2).putShort(value).array());
    }

    private void addV2Tags(ByteArrayOutputStream outputStream, byte[] data, String beaconId, Integer sequenceNumber, Integer totalBeacons) throws InvalidSerializationDataException {
        try {
            this.addTag(outputStream, Tags.PROTOCOL);
            this.addShort(outputStream, (short)5);
            if (this.visitorId != null) {
                byte[] visitorBytes = this.visitorId.getBytes();
                this.addSizedData(outputStream, Tags.VISITOR, visitorBytes);
            }
            if (this.visitId != null) {
                byte[] visitBytes = this.visitId.getBytes();
                this.addSizedData(outputStream, Tags.VISIT, visitBytes);
            }
            if (!BeaconDataType.SELF_MONITORING.equals((Object)this.type)) {
                this.addTag(outputStream, Tags.VISIT_STORE);
                outputStream.write(VisitStoreType.VISIT_STORE_TWO.getVisitStoreId());
            }
            this.addTag(outputStream, Tags.TYPE);
            outputStream.write(this.type.getSerializedId());
            if (this.startTime != null) {
                this.addTag(outputStream, Tags.START_TIME);
                this.addLong(outputStream, this.startTime);
            }
            if (this.endTime != null) {
                this.addTag(outputStream, Tags.END_TIME);
                this.addLong(outputStream, this.endTime);
            }
            if (sequenceNumber != -1 && totalBeacons != -1) {
                this.addTag(outputStream, Tags.SEQUENCE_NUMBER);
                this.addInt(outputStream, sequenceNumber);
                this.addTag(outputStream, Tags.TOTAL);
                this.addInt(outputStream, totalBeacons);
            }
            this.addSizedData(outputStream, Tags.BEACON_ID, beaconId.getBytes());
            if (this.type == BeaconDataType.IMAGE) {
                if (this.imageId != null) {
                    byte[] imageIdBytes = this.imageId.getBytes();
                    this.addSizedData(outputStream, Tags.IMAGE_ID, imageIdBytes);
                }
                this.addSizedData(outputStream, Tags.IMAGE, data);
            } else if (this.type == BeaconDataType.JSON) {
                this.addSizedData(outputStream, Tags.JSON, data);
            }
        }
        catch (IOException e) {
            throw new InvalidSerializationDataException("Impossible serialization. There was a problem trying to convert to bytes one of the fields");
        }
    }

    private void addV3Tags(ByteArrayOutputStream outputStream) throws InvalidSerializationDataException {
        try {
            if (this.type == BeaconDataType.JSON) {
                this.addTag(outputStream, Tags.DATA_VERSION);
                this.addShort(outputStream, this.dataVersion);
            }
        }
        catch (IOException e) {
            throw new InvalidSerializationDataException("Impossible serialization. There was a problem trying to convert to bytes data version");
        }
    }

    private void addV4Tags(ByteArrayOutputStream outputStream) throws InvalidSerializationDataException {
        try {
            if (this.type == BeaconDataType.SELF_MONITORING) {
                byte[] fullSessionMetricsBytes = this.fullSessionMetrics.getBytes();
                this.addSizedData(outputStream, Tags.FULL_SESSION_SELF_MONITORING, fullSessionMetricsBytes);
            }
        }
        catch (IOException e) {
            throw new InvalidSerializationDataException("Impossible serialization. There was a problem trying to convert to bytes full session metrics");
        }
    }

    private void addV5Tags(ByteArrayOutputStream outputStream, byte[] data) throws InvalidSerializationDataException {
        try {
            if (this.type == BeaconDataType.REASON && this.reason != null) {
                this.addTag(outputStream, Tags.REASON);
                outputStream.write(data);
            }
        }
        catch (IOException e) {
            throw new InvalidSerializationDataException("Impossible serialization. There was a problem trying to convert to bytes reason tag");
        }
    }

    private void validatePreconditions() throws InvalidSerializationDataException {
        if (this.type == null) {
            throw new InvalidSerializationDataException("Please specify Beacon type");
        }
        this.validateReplayBeaconsPreconditions();
        this.validateSelfMonitoringBeaconsPreconditions();
    }

    private void validateReplayBeaconsPreconditions() throws InvalidSerializationDataException {
        if (this.type != BeaconDataType.IMAGE && this.type != BeaconDataType.JSON && this.type != BeaconDataType.REASON) {
            return;
        }
        if (this.visitorId == null || this.visitId == null || this.endTime == null || this.startTime == null || this.type == BeaconDataType.IMAGE && (this.imageId == null || this.image == null) || this.type == BeaconDataType.JSON && this.json == null || this.type == BeaconDataType.REASON && this.reason == null) {
            throw new InvalidSerializationDataException("Wrong fields for " + (Object)((Object)this.type) + " beacon type");
        }
    }

    private void validateSelfMonitoringBeaconsPreconditions() throws InvalidSerializationDataException {
        if (this.type == BeaconDataType.SELF_MONITORING && this.fullSessionMetrics == null) {
            throw new InvalidSerializationDataException("Wrong fields for selfmonitoring beacon type");
        }
    }

    private byte[] getDataToBeSent() {
        if (this.type == BeaconDataType.IMAGE) {
            return this.image;
        }
        if (this.type == BeaconDataType.JSON) {
            return this.json.getBytes();
        }
        if (this.type == BeaconDataType.REASON) {
            return new byte[]{this.reason.getSerializedId()};
        }
        return this.fullSessionMetrics.getBytes();
    }
}

