/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.BooleanResultMessage;

final class NumberValueValidator {
    private static final double COMPARISON_ABSOLUTE_TOLERANCE = 1.0E-6;

    private NumberValueValidator() {
    }

    static BooleanResultMessage isSummaryValid(double min, double max, double sum, long count) {
        if (count < 0L) {
            return BooleanResultMessage.newInvalid(() -> String.format("count < 0: min: %f, max %f, sum: %f, count: %d", min, max, sum, count));
        }
        if (count == 0L && (min != 0.0 || max != 0.0 || sum != 0.0)) {
            return BooleanResultMessage.newInvalid(() -> String.format("count == 0 => min, max, sum != 0: min: %f, max %f, sum: %f, count: %d", min, max, sum, count));
        }
        if (count == 0L) {
            return BooleanResultMessage.newValid();
        }
        if (Double.isInfinite(min) || Double.isInfinite(max) || Double.isInfinite(sum)) {
            return BooleanResultMessage.newInvalid(() -> String.format("infinite values: min: %f, max %f, sum: %f, count: %d", min, max, sum, count));
        }
        if (Double.isNaN(min) || Double.isNaN(max) || Double.isNaN(sum)) {
            return BooleanResultMessage.newInvalid(() -> String.format("NaN values: min: %f, max %f, sum: %f, count: %d", min, max, sum, count));
        }
        if (max < min) {
            return BooleanResultMessage.newInvalid(() -> String.format("max < min: min: %f, max: %f, sum: %f, count: %d", min, max, sum, count));
        }
        double avg = sum / (double)count;
        if (!NumberValueValidator.lessOrEqualWithAbsoluteTolerance(min, avg) || !NumberValueValidator.lessOrEqualWithAbsoluteTolerance(avg, max)) {
            return BooleanResultMessage.newInvalid(() -> String.format("inconsistent gauge fields: min <= avg <= max doesn't hold: min: %f, max: %f, sum: %f, count: %d, avg: %f, tolerance: %f", min, max, sum, count, avg, 1.0E-6));
        }
        return BooleanResultMessage.newValid();
    }

    private static boolean lessOrEqualWithAbsoluteTolerance(double val1, double val2) {
        if (Double.valueOf(val1).equals(val2)) {
            return true;
        }
        return val1 - val2 <= 1.0E-6;
    }

    static BooleanResultMessage isValueValid(double value) {
        if (Double.isNaN(value)) {
            return BooleanResultMessage.newInvalid(() -> "Metric value was NaN");
        }
        if (Double.isInfinite(value)) {
            return BooleanResultMessage.newInvalid(() -> String.format("Metric value was infinite (%f)", value));
        }
        return BooleanResultMessage.newValid();
    }
}

