/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.file.util;

import com.dynatrace.file.util.FilePoller;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

class PollBasedFilePoller
extends FilePoller {
    private static final Logger LOGGER = Logger.getLogger(PollBasedFilePoller.class.getName());
    private static final String LOG_MESSAGE_FAILED_FILE_READ = "Failed to read file %s. Error: %s";
    private final AtomicBoolean changedSinceLastInquiry = new AtomicBoolean(false);
    private byte[] prevChecksumBytes;
    private final ScheduledFuture<?> worker;
    private final ScheduledExecutorService executorService;
    private MessageDigest md5;

    protected PollBasedFilePoller(Path filePath, Duration pollInterval) {
        super(filePath);
        if (pollInterval == null) {
            throw new IllegalArgumentException("Poll interval cannot be null");
        }
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(null, r, "PollBasedFilePoller");
                t.setDaemon(true);
                return t;
            }
        });
        LOGGER.finer(() -> String.format("Polling every %dms", pollInterval.toMillis()));
        this.worker = this.executorService.scheduleAtFixedRate(this::poll, pollInterval.toNanos(), pollInterval.toNanos(), TimeUnit.NANOSECONDS);
        this.prevChecksumBytes = this.getChecksumBytes();
    }

    @Override
    public boolean fileContentsUpdated() {
        return this.changedSinceLastInquiry.getAndSet(false);
    }

    private synchronized void poll() {
        byte[] latestChecksumBytes = this.getChecksumBytes();
        if (!Arrays.equals(latestChecksumBytes, this.prevChecksumBytes)) {
            this.prevChecksumBytes = latestChecksumBytes;
            if (latestChecksumBytes != null) {
                this.changedSinceLastInquiry.set(true);
            }
        }
    }

    private synchronized byte[] getChecksumBytes() {
        byte[] bytes = null;
        try {
            bytes = this.md5.digest(Files.readAllBytes(this.absoluteFilePath));
        }
        catch (IOException e) {
            LOGGER.warning(() -> String.format(LOG_MESSAGE_FAILED_FILE_READ, this.absoluteFilePath, e));
        }
        finally {
            this.md5.reset();
        }
        return bytes;
    }

    @Override
    public void close() throws IOException {
        this.worker.cancel(true);
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(50L, TimeUnit.MILLISECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.warning("failed to shut down poll based file poller: " + e);
        }
    }
}

