/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.MetricException;
import com.dynatrace.metric.util.MetricLineBuilderImpl;
import com.dynatrace.metric.util.MetricLinePreConfiguration;
import java.time.Instant;
import java.util.Map;

public interface MetricLineBuilder {
    public static MetricKeyStep create() {
        return MetricLineBuilderImpl.builder(MetricLinePreConfiguration.empty());
    }

    public static MetricKeyStep create(MetricLinePreConfiguration preConfig) {
        return MetricLineBuilderImpl.builder(preConfig);
    }

    public static interface MetadataStep {
        public MetadataStep description(String var1);

        public MetadataStep unit(String var1);

        public MetadataStep displayName(String var1);

        public String build();
    }

    public static interface BuildStep {
        public String build() throws MetricException;
    }

    public static interface TimestampOrBuildStep
    extends BuildStep {
        public BuildStep timestamp(Instant var1);
    }

    public static interface CounterStep {
        public TimestampOrBuildStep delta(double var1) throws MetricException;

        public MetadataStep metadata();
    }

    public static interface GaugeStep {
        public TimestampOrBuildStep summary(double var1, double var3, double var5, long var7) throws MetricException;

        public TimestampOrBuildStep value(double var1) throws MetricException;

        public MetadataStep metadata();
    }

    public static interface TypeStep {
        public TypeStep dimension(String var1, String var2) throws MetricException;

        public TypeStep dimensions(Map<String, String> var1) throws MetricException;

        public GaugeStep gauge();

        public CounterStep count();
    }

    public static interface MetricKeyStep {
        public TypeStep metricKey(String var1) throws MetricException;
    }
}

