/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.trim;

import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \t2\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001:\u0003\t\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/trim/TrimEventsUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/trim/TrimEventsUseCase$TrimEventsParams;", "Lcom/dynatrace/android/sessionreplay/model/Result;", "Lcom/dynatrace/android/sessionreplay/core/usecases/trim/TrimEventsUseCase$TrimEventsResult;", "", "()V", "start", "params", "Companion", "TrimEventsParams", "TrimEventsResult", "agent_release"})
public final class TrimEventsUseCase
implements UseCase<TrimEventsParams, Result<TrimEventsResult, Unit>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long MIN_TIME_IN_MS = 10000L;
    private static final long MIN_SIZE_IN_B = 307200L;

    @Override
    @NotNull
    public Result<TrimEventsResult, Unit> start(@NotNull TrimEventsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Collection collection = params.getEvents();
        if (collection == null || collection.isEmpty()) {
            return (Result)new Result.Success((Object)new TrimEventsResult(CollectionsKt.emptyList(), 0L, 0L, CollectionsKt.emptyList()));
        }
        List trimmedEvents = new ArrayList();
        int splitIndex = -1;
        long endTime = params.getEvents().get(0).getStartTime().getTime();
        long accumulatedSize = 0L;
        HashSet<String> processedScreenshots = new HashSet<String>();
        Iterator<Event> iterator = params.getEvents().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Event event = iterator.next();
            trimmedEvents.add(event);
            String screenshotId = event.getScreenshotId();
            CharSequence charSequence = screenshotId;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !processedScreenshots.contains(screenshotId)) {
                accumulatedSize += event.getScreenshotSize();
                processedScreenshots.add(screenshotId);
            }
            if (endTime - event.getStartTime().getTime() <= params.getMinTime() || accumulatedSize <= params.getMinSize()) continue;
            splitIndex = index + 1;
            break;
        }
        long accumulatedTime = endTime - ((Event)CollectionsKt.last((List)trimmedEvents)).getStartTime().getTime();
        List<Event> toRemoveEvents = splitIndex >= 0 && splitIndex < params.getEvents().size() ? params.getEvents().subList(splitIndex, params.getEvents().size()) : CollectionsKt.emptyList();
        return (Result)new Result.Success((Object)new TrimEventsResult(trimmedEvents, accumulatedTime, accumulatedSize, (List<? extends Event>)toRemoveEvents));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/trim/TrimEventsUseCase$Companion;", "", "()V", "MIN_SIZE_IN_B", "", "MIN_TIME_IN_MS", "agent_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/trim/TrimEventsUseCase$TrimEventsParams;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "events", "", "Lcom/dynatrace/android/sessionreplay/model/Event;", "minTime", "", "minSize", "(Ljava/util/List;JJ)V", "getEvents", "()Ljava/util/List;", "getMinSize", "()J", "getMinTime", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "agent_release"})
    public static final class TrimEventsParams
    extends UseCase.Params {
        @NotNull
        private final List<Event> events;
        private final long minTime;
        private final long minSize;

        public TrimEventsParams(@NotNull List<? extends Event> events, long minTime, long minSize) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.events = events;
            this.minTime = minTime;
            this.minSize = minSize;
        }

        public /* synthetic */ TrimEventsParams(List list, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = 10000L;
            }
            if ((n & 4) != 0) {
                l2 = 307200L;
            }
            this(list, l, l2);
        }

        @NotNull
        public final List<Event> getEvents() {
            return this.events;
        }

        public final long getMinTime() {
            return this.minTime;
        }

        public final long getMinSize() {
            return this.minSize;
        }

        @NotNull
        public final List<Event> component1() {
            return this.events;
        }

        public final long component2() {
            return this.minTime;
        }

        public final long component3() {
            return this.minSize;
        }

        @NotNull
        public final TrimEventsParams copy(@NotNull List<? extends Event> events, long minTime, long minSize) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            return new TrimEventsParams(events, minTime, minSize);
        }

        public static /* synthetic */ TrimEventsParams copy$default(TrimEventsParams trimEventsParams, List list, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                list = trimEventsParams.events;
            }
            if ((n & 2) != 0) {
                l = trimEventsParams.minTime;
            }
            if ((n & 4) != 0) {
                l2 = trimEventsParams.minSize;
            }
            return trimEventsParams.copy(list, l, l2);
        }

        @NotNull
        public String toString() {
            return "TrimEventsParams(events=" + this.events + ", minTime=" + this.minTime + ", minSize=" + this.minSize + ')';
        }

        public int hashCode() {
            int result = ((Object)this.events).hashCode();
            result = result * 31 + Long.hashCode(this.minTime);
            result = result * 31 + Long.hashCode(this.minSize);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrimEventsParams)) {
                return false;
            }
            TrimEventsParams trimEventsParams = (TrimEventsParams)other;
            if (!Intrinsics.areEqual(this.events, trimEventsParams.events)) {
                return false;
            }
            if (this.minTime != trimEventsParams.minTime) {
                return false;
            }
            return this.minSize == trimEventsParams.minSize;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\tR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/trim/TrimEventsUseCase$TrimEventsResult;", "", "trimmedEvents", "", "Lcom/dynatrace/android/sessionreplay/model/Event;", "trimmedTime", "", "trimmedSize", "toRemoveEvents", "(Ljava/util/List;JJLjava/util/List;)V", "getToRemoveEvents", "()Ljava/util/List;", "getTrimmedEvents", "getTrimmedSize", "()J", "getTrimmedTime", "agent_release"})
    public static final class TrimEventsResult {
        @NotNull
        private final List<Event> trimmedEvents;
        private final long trimmedTime;
        private final long trimmedSize;
        @NotNull
        private final List<Event> toRemoveEvents;

        public TrimEventsResult(@NotNull List<? extends Event> trimmedEvents, long trimmedTime, long trimmedSize, @NotNull List<? extends Event> toRemoveEvents) {
            Intrinsics.checkNotNullParameter(trimmedEvents, (String)"trimmedEvents");
            Intrinsics.checkNotNullParameter(toRemoveEvents, (String)"toRemoveEvents");
            this.trimmedEvents = trimmedEvents;
            this.trimmedTime = trimmedTime;
            this.trimmedSize = trimmedSize;
            this.toRemoveEvents = toRemoveEvents;
        }

        @NotNull
        public final List<Event> getTrimmedEvents() {
            return this.trimmedEvents;
        }

        public final long getTrimmedTime() {
            return this.trimmedTime;
        }

        public final long getTrimmedSize() {
            return this.trimmedSize;
        }

        @NotNull
        public final List<Event> getToRemoveEvents() {
            return this.toRemoveEvents;
        }
    }
}

