/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.syncjob;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.usecases.beacon.BuildDataBeaconsUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.datajob.SaveDataJobUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.screenshotjob.StoreScreenshotJobUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.GetSessionUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.sessionchunk.CreateSessionChunkUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.syncjob.CreateSyncJobsResult;
import com.dynatrace.android.sessionreplay.model.BeaconSerializationError;
import com.dynatrace.android.sessionreplay.model.DataError;
import com.dynatrace.android.sessionreplay.model.DataJob;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.android.sessionreplay.model.ScreenshotJob;
import com.dynatrace.android.sessionreplay.model.Session;
import com.dynatrace.android.sessionreplay.model.SessionChunk;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001B-\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u001c\u001a\u00020\u0002H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/syncjob/CreateSyncJobsUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "", "Lcom/dynatrace/android/sessionreplay/model/Result;", "Lcom/dynatrace/android/sessionreplay/core/usecases/syncjob/CreateSyncJobsResult;", "Lcom/dynatrace/android/sessionreplay/model/DataError;", "getSessionUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/GetSessionUseCase;", "saveDataJobUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/datajob/SaveDataJobUseCase;", "storeScreenshotJobUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshotjob/StoreScreenshotJobUseCase;", "buildDataBeaconsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildDataBeaconsUseCase;", "createSessionChunkUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/sessionchunk/CreateSessionChunkUseCase;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/session/GetSessionUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/datajob/SaveDataJobUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/screenshotjob/StoreScreenshotJobUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildDataBeaconsUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/sessionchunk/CreateSessionChunkUseCase;)V", "buildDataBeacons", "", "", "sessionChunk", "Lcom/dynatrace/android/sessionreplay/model/SessionChunk;", "saveDataJob", "", "beacon", "chunk", "saveScreenshotJob", "", "visitId", "visitorId", "screenshot", "Lcom/dynatrace/android/sessionreplay/model/SessionChunk$ScreenshotInfo;", "start", "agent_release"})
@SourceDebugExtension(value={"SMAP\nCreateSyncJobsUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateSyncJobsUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/syncjob/CreateSyncJobsUseCase\n+ 2 Result.kt\ncom/dynatrace/android/sessionreplay/model/Result\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n33#2,2:80\n36#2:86\n40#2,4:87\n26#2,3:91\n1855#3,2:82\n1855#3,2:84\n*S KotlinDebug\n*F\n+ 1 CreateSyncJobsUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/syncjob/CreateSyncJobsUseCase\n*L\n28#1:80,2\n28#1:86\n56#1:87,4\n67#1:91,3\n32#1:82,2\n37#1:84,2\n*E\n"})
public final class CreateSyncJobsUseCase
implements UseCase<String, Result<CreateSyncJobsResult, DataError>> {
    @NotNull
    private final GetSessionUseCase getSessionUseCase;
    @NotNull
    private final SaveDataJobUseCase saveDataJobUseCase;
    @NotNull
    private final StoreScreenshotJobUseCase storeScreenshotJobUseCase;
    @NotNull
    private final BuildDataBeaconsUseCase buildDataBeaconsUseCase;
    @NotNull
    private final CreateSessionChunkUseCase createSessionChunkUseCase;

    public CreateSyncJobsUseCase(@NotNull GetSessionUseCase getSessionUseCase, @NotNull SaveDataJobUseCase saveDataJobUseCase, @NotNull StoreScreenshotJobUseCase storeScreenshotJobUseCase, @NotNull BuildDataBeaconsUseCase buildDataBeaconsUseCase, @NotNull CreateSessionChunkUseCase createSessionChunkUseCase) {
        Intrinsics.checkNotNullParameter((Object)getSessionUseCase, (String)"getSessionUseCase");
        Intrinsics.checkNotNullParameter((Object)saveDataJobUseCase, (String)"saveDataJobUseCase");
        Intrinsics.checkNotNullParameter((Object)storeScreenshotJobUseCase, (String)"storeScreenshotJobUseCase");
        Intrinsics.checkNotNullParameter((Object)buildDataBeaconsUseCase, (String)"buildDataBeaconsUseCase");
        Intrinsics.checkNotNullParameter((Object)createSessionChunkUseCase, (String)"createSessionChunkUseCase");
        this.getSessionUseCase = getSessionUseCase;
        this.saveDataJobUseCase = saveDataJobUseCase;
        this.storeScreenshotJobUseCase = storeScreenshotJobUseCase;
        this.buildDataBeaconsUseCase = buildDataBeaconsUseCase;
        this.createSessionChunkUseCase = createSessionChunkUseCase;
    }

    @Override
    @NotNull
    public Result<CreateSyncJobsResult, DataError> start(@NotNull String visitId) {
        Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
        Result<Session, DataError> this_$iv = this.getSessionUseCase.start(visitId);
        boolean $i$f$onSuccess = false;
        if (this_$iv instanceof Result.Success) {
            Result result;
            SessionChunk sessionChunk;
            Session session = (Session)((Result.Success)this_$iv).getData();
            boolean bl = false;
            SessionChunk sessionChunk2 = sessionChunk = this.createSessionChunkUseCase.start(session);
            if (sessionChunk2 != null) {
                SessionChunk chunk = sessionChunk2;
                boolean bl2 = false;
                Iterable $this$forEach$iv = this.buildDataBeacons(chunk);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    byte[] dataBeacon = (byte[])element$iv;
                    boolean bl3 = false;
                    this.saveDataJob(dataBeacon, chunk);
                }
                int screenshotJobCount = 0;
                Iterable $this$forEach$iv2 = chunk.getScreenshots();
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    SessionChunk.ScreenshotInfo it = (SessionChunk.ScreenshotInfo)element$iv;
                    boolean bl4 = false;
                    boolean wasJobCreated = this.saveScreenshotJob(sessionChunk.getVisitId(), sessionChunk.getVisitorId(), it);
                    screenshotJobCount += wasJobCreated ? 1 : 0;
                }
                result = (Result)new Result.Success((Object)new CreateSyncJobsResult(screenshotJobCount));
            } else {
                result = (Result)new Result.Error((Object)DataError.NotFound.INSTANCE);
            }
            return result;
        }
        return (Result)new Result.Error((Object)DataError.NotFound.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean saveScreenshotJob(String visitId, String visitorId, SessionChunk.ScreenshotInfo screenshot) {
        void this_$iv;
        boolean success = false;
        success = true;
        Result<ScreenshotJob, DataError> result = this.storeScreenshotJobUseCase.start(new ScreenshotJob(visitId, visitorId, screenshot.getMd5(), screenshot.getTimestamp(), null, 16, null));
        boolean $i$f$onError = false;
        if (this_$iv instanceof Result.Error) {
            DataError error = (DataError)((Result.Error)this_$iv).getError();
            boolean bl = false;
            DTLogger.INSTANCE.error("Error saving screenshot " + screenshot + ".md5: " + error);
            success = false;
        }
        return success;
    }

    private final List<byte[]> buildDataBeacons(SessionChunk sessionChunk) {
        Object object;
        Result<List<byte[]>, BeaconSerializationError.BeaconSerialization> this_$iv = this.buildDataBeaconsUseCase.start(new BuildDataBeaconsUseCase.Params(sessionChunk));
        boolean $i$f$getOrElse = false;
        Result<List<byte[]>, BeaconSerializationError.BeaconSerialization> result = this_$iv;
        if (result instanceof Result.Success) {
            object = ((Result.Success)this_$iv).getData();
        } else if (result instanceof Result.Error) {
            BeaconSerializationError.BeaconSerialization it = (BeaconSerializationError.BeaconSerialization)((Result.Error)this_$iv).getError();
            boolean bl = false;
            object = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (List)object;
    }

    private final void saveDataJob(byte[] beacon, SessionChunk chunk) {
        this.saveDataJobUseCase.start(new SaveDataJobUseCase.SaveDataJobParams(new DataJob(1, beacon, chunk.getVisitId(), null, 8, null)));
    }
}

