/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.sync;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.manager.SessionErrorHandler;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.usecases.beacon.BuildImageBeaconsUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.beacon.SendBeaconUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.beacon.model.BeaconResult;
import com.dynatrace.android.sessionreplay.core.usecases.screenshot.GetScreenshotUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.screenshotjob.DeleteScreenshotJobUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.screenshotjob.GetSessionScreenshotJobsUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.sync.SyncJobsResult;
import com.dynatrace.android.sessionreplay.model.APIError;
import com.dynatrace.android.sessionreplay.model.BeaconSerializationError;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.android.sessionreplay.model.ScreenshotError;
import com.dynatrace.android.sessionreplay.model.ScreenshotJob;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001d2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J \u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionScreenshotJobsUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "", "Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncJobsResult;", "getSessionScreenshotJobsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshotjob/GetSessionScreenshotJobsUseCase;", "getScreenshotUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/GetScreenshotUseCase;", "buildImageBeaconsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildImageBeaconsUseCase;", "sendBeaconUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/SendBeaconUseCase;", "deleteScreenshotJobUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshotjob/DeleteScreenshotJobUseCase;", "sessionErrorHandler", "Lcom/dynatrace/android/sessionreplay/core/manager/SessionErrorHandler;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/screenshotjob/GetSessionScreenshotJobsUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/GetScreenshotUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildImageBeaconsUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/SendBeaconUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/screenshotjob/DeleteScreenshotJobUseCase;Lcom/dynatrace/android/sessionreplay/core/manager/SessionErrorHandler;)V", "jobFailed", "", "stopped", "successJobs", "", "onBeaconsSerialized", "", "screenshotJob", "Lcom/dynatrace/android/sessionreplay/model/ScreenshotJob;", "screenshot", "", "serializedBeacons", "", "isLastJob", "onScreenshotRetrieved", "start", "visitId", "agent_release"})
@SourceDebugExtension(value={"SMAP\nSyncSessionScreenshotJobsUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncSessionScreenshotJobsUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionScreenshotJobsUseCase\n+ 2 Result.kt\ncom/dynatrace/android/sessionreplay/model/Result\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n33#2,4:118\n40#2,4:122\n33#2,4:126\n40#2,4:130\n33#2,4:136\n40#2,4:140\n1864#3,2:134\n1866#3:144\n*S KotlinDebug\n*F\n+ 1 SyncSessionScreenshotJobsUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionScreenshotJobsUseCase\n*L\n39#1:118,4\n42#1:122,4\n63#1:126,4\n66#1:130,4\n92#1:136,4\n100#1:140,4\n83#1:134,2\n83#1:144\n*E\n"})
public final class SyncSessionScreenshotJobsUseCase
implements UseCase<String, SyncJobsResult> {
    @NotNull
    private final GetSessionScreenshotJobsUseCase getSessionScreenshotJobsUseCase;
    @NotNull
    private final GetScreenshotUseCase getScreenshotUseCase;
    @NotNull
    private final BuildImageBeaconsUseCase buildImageBeaconsUseCase;
    @NotNull
    private final SendBeaconUseCase sendBeaconUseCase;
    @NotNull
    private final DeleteScreenshotJobUseCase deleteScreenshotJobUseCase;
    @NotNull
    private final SessionErrorHandler sessionErrorHandler;
    private int successJobs;
    private boolean stopped;
    private boolean jobFailed;

    public SyncSessionScreenshotJobsUseCase(@NotNull GetSessionScreenshotJobsUseCase getSessionScreenshotJobsUseCase, @NotNull GetScreenshotUseCase getScreenshotUseCase, @NotNull BuildImageBeaconsUseCase buildImageBeaconsUseCase, @NotNull SendBeaconUseCase sendBeaconUseCase, @NotNull DeleteScreenshotJobUseCase deleteScreenshotJobUseCase, @NotNull SessionErrorHandler sessionErrorHandler) {
        Intrinsics.checkNotNullParameter((Object)getSessionScreenshotJobsUseCase, (String)"getSessionScreenshotJobsUseCase");
        Intrinsics.checkNotNullParameter((Object)getScreenshotUseCase, (String)"getScreenshotUseCase");
        Intrinsics.checkNotNullParameter((Object)buildImageBeaconsUseCase, (String)"buildImageBeaconsUseCase");
        Intrinsics.checkNotNullParameter((Object)sendBeaconUseCase, (String)"sendBeaconUseCase");
        Intrinsics.checkNotNullParameter((Object)deleteScreenshotJobUseCase, (String)"deleteScreenshotJobUseCase");
        Intrinsics.checkNotNullParameter((Object)sessionErrorHandler, (String)"sessionErrorHandler");
        this.getSessionScreenshotJobsUseCase = getSessionScreenshotJobsUseCase;
        this.getScreenshotUseCase = getScreenshotUseCase;
        this.buildImageBeaconsUseCase = buildImageBeaconsUseCase;
        this.sendBeaconUseCase = sendBeaconUseCase;
        this.deleteScreenshotJobUseCase = deleteScreenshotJobUseCase;
        this.sessionErrorHandler = sessionErrorHandler;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SyncJobsResult start(@NotNull String visitId) {
        Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
        List<ScreenshotJob> screenshotJobs = this.getSessionScreenshotJobsUseCase.start(visitId);
        for (IndexedValue screenshotJob : CollectionsKt.withIndex((Iterable)screenshotJobs)) {
            void this_$iv;
            boolean isLastJob = screenshotJob.getIndex() == CollectionsKt.getLastIndex(screenshotJobs);
            Result<byte[], ScreenshotError> result = this.getScreenshotUseCase.start(new GetScreenshotUseCase.Params(((ScreenshotJob)screenshotJob.getValue()).getScreenshotId(), ((ScreenshotJob)screenshotJob.getValue()).getVisitId()));
            boolean $i$f$onSuccess = false;
            if (this_$iv instanceof Result.Success) {
                byte[] screenshot = (byte[])((Result.Success)this_$iv).getData();
                boolean bl = false;
                this.onScreenshotRetrieved((ScreenshotJob)screenshotJob.getValue(), screenshot, isLastJob);
            }
            boolean $i$f$onError = false;
            if (this_$iv instanceof Result.Error) {
                ScreenshotError it = (ScreenshotError)((Result.Error)this_$iv).getError();
                boolean bl = false;
                DTLogger.INSTANCE.error("Error retrieving screenshot " + ((ScreenshotJob)screenshotJob.getValue()).getScreenshotId() + " from storage");
            }
            if (this.jobFailed) break;
            if (!this.stopped) continue;
            return SyncJobsResult.Stopped.INSTANCE;
        }
        return new SyncJobsResult.Finished(screenshotJobs.size(), this.successJobs);
    }

    /*
     * WARNING - void declaration
     */
    private final void onScreenshotRetrieved(ScreenshotJob screenshotJob, byte[] screenshot, boolean isLastJob) {
        void this_$iv;
        Result<List<byte[]>, BeaconSerializationError.BeaconSerialization> result = this.buildImageBeaconsUseCase.start(new BuildImageBeaconsUseCase.Params(screenshotJob.getVisitorId(), screenshotJob.getVisitId(), screenshot, screenshotJob.getScreenshotId(), screenshotJob.getTime().getTime()));
        boolean $i$f$onSuccess = false;
        if (this_$iv instanceof Result.Success) {
            List serializedBeacons = (List)((Result.Success)this_$iv).getData();
            boolean bl = false;
            this.onBeaconsSerialized(screenshotJob, screenshot, serializedBeacons, isLastJob);
        }
        boolean $i$f$onError = false;
        if (this_$iv instanceof Result.Error) {
            BeaconSerializationError.BeaconSerialization it = (BeaconSerializationError.BeaconSerialization)((Result.Error)this_$iv).getError();
            boolean bl = false;
            DTLogger.INSTANCE.error("Error serializing beacons for screenshot " + screenshotJob.getScreenshotId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onBeaconsSerialized(ScreenshotJob screenshotJob, byte[] screenshot, List<byte[]> serializedBeacons, boolean isLastJob) {
        DTLogger.INSTANCE.sync("Syncing ScreenshotJob for visit id: " + screenshotJob.getVisitId() + " and image id: " + screenshotJob.getScreenshotId() + " - " + screenshot.length + " Bytes");
        Iterable $this$forEachIndexed$iv = serializedBeacons;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String it;
            void this_$iv;
            void serializedBeacon;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            byte[] byArray = (byte[])item$iv;
            int beaconIndex = n;
            boolean bl = false;
            boolean isLastBeacon = beaconIndex == CollectionsKt.getLastIndex(serializedBeacons);
            Result<String, APIError> result = this.sendBeaconUseCase.start(new SendBeaconUseCase.Params(screenshotJob.getVisitId(), (byte[])serializedBeacon, !isLastJob || !isLastBeacon));
            boolean $i$f$onSuccess = false;
            if (this_$iv instanceof Result.Success) {
                it = (String)((Result.Success)this_$iv).getData();
                boolean bl2 = false;
                if (isLastBeacon) {
                    int n2 = this.successJobs;
                    this.successJobs = n2 + 1;
                    this.deleteScreenshotJobUseCase.start(new DeleteScreenshotJobUseCase.DeleteScreenshotJobParams(screenshotJob.getId()));
                }
            }
            boolean $i$f$onError = false;
            if (!(this_$iv instanceof Result.Error)) continue;
            it = (APIError)((Result.Error)this_$iv).getError();
            boolean bl3 = false;
            BeaconResult beaconResult = this.sessionErrorHandler.handleBeaconError("Sending data job with id " + screenshotJob.getId(), (APIError)it);
            if (beaconResult == BeaconResult.STOP_ERROR) {
                DTLogger.INSTANCE.error("Stop received sending beacon");
                this.stopped = true;
                continue;
            }
            DTLogger.INSTANCE.error("Error sending beacon");
            this.jobFailed = true;
        }
    }
}

