/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.sync;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.configuration.NetworkConfiguration;
import com.dynatrace.android.sessionreplay.core.configuration.TenantConfiguration;
import com.dynatrace.android.sessionreplay.core.configuration.TransmissionMode;
import com.dynatrace.android.sessionreplay.core.connection.NetworkStatus;
import com.dynatrace.android.sessionreplay.core.connection.NetworkStatusProvider;
import com.dynatrace.android.sessionreplay.core.manager.model.SelfMonitoringFlags;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.usecases.UseCaseNoParamsNorResult;
import com.dynatrace.android.sessionreplay.core.usecases.session.GetAllSessionsUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.SetSessionPartiallySentUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.sync.SyncJobsResult;
import com.dynatrace.android.sessionreplay.core.usecases.sync.SyncSessionDataJobsUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.sync.SyncSessionScreenshotJobsUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.sync.SyncSessionSelfMonitoringDataUseCase;
import com.dynatrace.android.sessionreplay.model.Session;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncJobsUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCaseNoParamsNorResult;", "getAllSessionsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/GetAllSessionsUseCase;", "syncSessionDataJobsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionDataJobsUseCase;", "syncSessionScreenshotJobsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionScreenshotJobsUseCase;", "syncSessionSelfMonitoringDataUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionSelfMonitoringDataUseCase;", "setSessionPartiallySentUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/SetSessionPartiallySentUseCase;", "networkStatusProvider", "Lcom/dynatrace/android/sessionreplay/core/connection/NetworkStatusProvider;", "networkConfig", "Lcom/dynatrace/android/sessionreplay/core/configuration/NetworkConfiguration;", "tenantConfiguration", "Lcom/dynatrace/android/sessionreplay/core/configuration/TenantConfiguration;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/session/GetAllSessionsUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionDataJobsUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionScreenshotJobsUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionSelfMonitoringDataUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/session/SetSessionPartiallySentUseCase;Lcom/dynatrace/android/sessionreplay/core/connection/NetworkStatusProvider;Lcom/dynatrace/android/sessionreplay/core/configuration/NetworkConfiguration;Lcom/dynatrace/android/sessionreplay/core/configuration/TenantConfiguration;)V", "canContinue", "", "handleSessionJobsResult", "", "result", "Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncJobsResult;", "session", "Lcom/dynatrace/android/sessionreplay/model/Session;", "isDisconnected", "networkStatus", "Lcom/dynatrace/android/sessionreplay/core/connection/NetworkStatus;", "isUnmetered", "start", "syncDataJobs", "syncScreenshotJobs", "syncSelfMonitoringData", "visitId", "", "agent_release"})
@SourceDebugExtension(value={"SMAP\nSyncJobsUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncJobsUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/sync/SyncJobsUseCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1855#2,2:102\n*S KotlinDebug\n*F\n+ 1 SyncJobsUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/sync/SyncJobsUseCase\n*L\n37#1:102,2\n*E\n"})
public final class SyncJobsUseCase
implements UseCaseNoParamsNorResult {
    @NotNull
    private final GetAllSessionsUseCase getAllSessionsUseCase;
    @NotNull
    private final SyncSessionDataJobsUseCase syncSessionDataJobsUseCase;
    @NotNull
    private final SyncSessionScreenshotJobsUseCase syncSessionScreenshotJobsUseCase;
    @NotNull
    private final SyncSessionSelfMonitoringDataUseCase syncSessionSelfMonitoringDataUseCase;
    @NotNull
    private final SetSessionPartiallySentUseCase setSessionPartiallySentUseCase;
    @NotNull
    private final NetworkStatusProvider networkStatusProvider;
    @NotNull
    private final NetworkConfiguration networkConfig;
    @NotNull
    private final TenantConfiguration tenantConfiguration;
    private boolean canContinue;

    public SyncJobsUseCase(@NotNull GetAllSessionsUseCase getAllSessionsUseCase, @NotNull SyncSessionDataJobsUseCase syncSessionDataJobsUseCase, @NotNull SyncSessionScreenshotJobsUseCase syncSessionScreenshotJobsUseCase, @NotNull SyncSessionSelfMonitoringDataUseCase syncSessionSelfMonitoringDataUseCase, @NotNull SetSessionPartiallySentUseCase setSessionPartiallySentUseCase, @NotNull NetworkStatusProvider networkStatusProvider, @NotNull NetworkConfiguration networkConfig, @NotNull TenantConfiguration tenantConfiguration) {
        Intrinsics.checkNotNullParameter((Object)getAllSessionsUseCase, (String)"getAllSessionsUseCase");
        Intrinsics.checkNotNullParameter((Object)syncSessionDataJobsUseCase, (String)"syncSessionDataJobsUseCase");
        Intrinsics.checkNotNullParameter((Object)syncSessionScreenshotJobsUseCase, (String)"syncSessionScreenshotJobsUseCase");
        Intrinsics.checkNotNullParameter((Object)syncSessionSelfMonitoringDataUseCase, (String)"syncSessionSelfMonitoringDataUseCase");
        Intrinsics.checkNotNullParameter((Object)setSessionPartiallySentUseCase, (String)"setSessionPartiallySentUseCase");
        Intrinsics.checkNotNullParameter((Object)networkStatusProvider, (String)"networkStatusProvider");
        Intrinsics.checkNotNullParameter((Object)networkConfig, (String)"networkConfig");
        Intrinsics.checkNotNullParameter((Object)tenantConfiguration, (String)"tenantConfiguration");
        this.getAllSessionsUseCase = getAllSessionsUseCase;
        this.syncSessionDataJobsUseCase = syncSessionDataJobsUseCase;
        this.syncSessionScreenshotJobsUseCase = syncSessionScreenshotJobsUseCase;
        this.syncSessionSelfMonitoringDataUseCase = syncSessionSelfMonitoringDataUseCase;
        this.setSessionPartiallySentUseCase = setSessionPartiallySentUseCase;
        this.networkStatusProvider = networkStatusProvider;
        this.networkConfig = networkConfig;
        this.tenantConfiguration = tenantConfiguration;
        this.canContinue = true;
    }

    @Override
    public void start() {
        NetworkStatus networkStatus = this.networkStatusProvider.getNetworkStatus();
        if (this.isDisconnected(networkStatus)) {
            DTLogger.INSTANCE.info("Device has no internet connection, ignoring sync.");
        } else {
            boolean isMeteredAllowed = this.networkConfig.getTransmissionMode() == TransmissionMode.ALWAYS;
            Iterable $this$forEach$iv = (Iterable)this.getAllSessionsUseCase.start();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Session session = (Session)element$iv;
                boolean bl = false;
                this.syncDataJobs(session);
                if (this.isUnmetered(networkStatus) || isMeteredAllowed) {
                    this.syncScreenshotJobs(session);
                } else {
                    DTLogger.INSTANCE.info("Device is on a metered connection, ignoring screenshot sync.");
                }
                this.syncSelfMonitoringData(session.getVisitId());
            }
        }
    }

    private final void syncDataJobs(Session session) {
        if (!this.canContinue) {
            return;
        }
        SyncJobsResult $this$syncDataJobs_u24lambda_u241 = this.syncSessionDataJobsUseCase.start(session.getVisitId());
        boolean bl = false;
        this.handleSessionJobsResult($this$syncDataJobs_u24lambda_u241, session);
    }

    private final void syncScreenshotJobs(Session session) {
        if (!this.canContinue) {
            return;
        }
        SyncJobsResult $this$syncScreenshotJobs_u24lambda_u242 = this.syncSessionScreenshotJobsUseCase.start(session.getVisitId());
        boolean bl = false;
        this.handleSessionJobsResult($this$syncScreenshotJobs_u24lambda_u242, session);
    }

    private final void handleSessionJobsResult(SyncJobsResult result, Session session) {
        SyncJobsResult syncJobsResult = result;
        if (syncJobsResult instanceof SyncJobsResult.Stopped) {
            this.canContinue = false;
        } else if (syncJobsResult instanceof SyncJobsResult.Finished) {
            if (!session.isPartiallySent() && ((SyncJobsResult.Finished)result).getSuccessJobs() > 0) {
                this.setSessionPartiallySentUseCase.start(session.getVisitId());
            }
            if (((SyncJobsResult.Finished)result).getSuccessJobs() != ((SyncJobsResult.Finished)result).getTotalJobs()) {
                this.canContinue = false;
            }
        }
    }

    private final void syncSelfMonitoringData(String visitId) {
        if (!this.canContinue) {
            return;
        }
        this.syncSessionSelfMonitoringDataUseCase.start(new SyncSessionSelfMonitoringDataUseCase.Params(visitId, new SelfMonitoringFlags(this.tenantConfiguration.getSelfMonitoringFlags())));
    }

    private final boolean isDisconnected(NetworkStatus networkStatus) {
        return networkStatus == NetworkStatus.NO_CONNECTION;
    }

    private final boolean isUnmetered(NetworkStatus networkStatus) {
        return networkStatus == NetworkStatus.UNMETERED_CONNECTION;
    }

    @Override
    public void start(@NotNull UseCase.EmptyParams params) {
        UseCaseNoParamsNorResult.DefaultImpls.start(this, params);
    }
}

