/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.sync;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.manager.SessionErrorHandler;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.usecases.UseCaseNoResult;
import com.dynatrace.android.sessionreplay.core.usecases.beacon.BuildReasonBeaconUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.beacon.SendBeaconUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.beacon.model.ReasonBeaconData;
import com.dynatrace.android.sessionreplay.core.usecases.event.GetAllEventsByVisitIdUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.GetSessionUseCase;
import com.dynatrace.android.sessionreplay.model.APIError;
import com.dynatrace.android.sessionreplay.model.BeaconSerializationError;
import com.dynatrace.android.sessionreplay.model.DataError;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.android.sessionreplay.model.Session;
import com.dynatrace.protocols.mobile.sessionreplay.ReasonTag;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SendReasonBeaconUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCaseNoResult;", "Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SendReasonBeaconUseCase$Params;", "getSessionUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/GetSessionUseCase;", "getAllEventsByVisitIdUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/event/GetAllEventsByVisitIdUseCase;", "buildReasonBeaconUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildReasonBeaconUseCase;", "sendBeaconUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/SendBeaconUseCase;", "sessionErrorHandler", "Lcom/dynatrace/android/sessionreplay/core/manager/SessionErrorHandler;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/session/GetSessionUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/event/GetAllEventsByVisitIdUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildReasonBeaconUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/SendBeaconUseCase;Lcom/dynatrace/android/sessionreplay/core/manager/SessionErrorHandler;)V", "buildReasonBeacon", "", "session", "Lcom/dynatrace/android/sessionreplay/model/Session;", "eventTimestamp", "", "reason", "Lcom/dynatrace/protocols/mobile/sessionreplay/ReasonTag;", "getReasonBeaconData", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/model/ReasonBeaconData;", "onGetSession", "sendReasonBeacon", "reasonBeacon", "", "visitId", "", "start", "params", "Params", "agent_release"})
@SourceDebugExtension(value={"SMAP\nSendReasonBeaconUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SendReasonBeaconUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/sync/SendReasonBeaconUseCase\n+ 2 Result.kt\ncom/dynatrace/android/sessionreplay/model/Result\n*L\n1#1,90:1\n33#2,4:91\n40#2,4:95\n33#2,4:99\n40#2,4:103\n40#2,4:107\n*S KotlinDebug\n*F\n+ 1 SendReasonBeaconUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/sync/SendReasonBeaconUseCase\n*L\n25#1:91,4\n28#1:95,4\n52#1:99,4\n54#1:103,4\n68#1:107,4\n*E\n"})
public final class SendReasonBeaconUseCase
implements UseCaseNoResult<Params> {
    @NotNull
    private final GetSessionUseCase getSessionUseCase;
    @NotNull
    private final GetAllEventsByVisitIdUseCase getAllEventsByVisitIdUseCase;
    @NotNull
    private final BuildReasonBeaconUseCase buildReasonBeaconUseCase;
    @NotNull
    private final SendBeaconUseCase sendBeaconUseCase;
    @NotNull
    private final SessionErrorHandler sessionErrorHandler;

    public SendReasonBeaconUseCase(@NotNull GetSessionUseCase getSessionUseCase, @NotNull GetAllEventsByVisitIdUseCase getAllEventsByVisitIdUseCase, @NotNull BuildReasonBeaconUseCase buildReasonBeaconUseCase, @NotNull SendBeaconUseCase sendBeaconUseCase, @NotNull SessionErrorHandler sessionErrorHandler) {
        Intrinsics.checkNotNullParameter((Object)getSessionUseCase, (String)"getSessionUseCase");
        Intrinsics.checkNotNullParameter((Object)getAllEventsByVisitIdUseCase, (String)"getAllEventsByVisitIdUseCase");
        Intrinsics.checkNotNullParameter((Object)buildReasonBeaconUseCase, (String)"buildReasonBeaconUseCase");
        Intrinsics.checkNotNullParameter((Object)sendBeaconUseCase, (String)"sendBeaconUseCase");
        Intrinsics.checkNotNullParameter((Object)sessionErrorHandler, (String)"sessionErrorHandler");
        this.getSessionUseCase = getSessionUseCase;
        this.getAllEventsByVisitIdUseCase = getAllEventsByVisitIdUseCase;
        this.buildReasonBeaconUseCase = buildReasonBeaconUseCase;
        this.sendBeaconUseCase = sendBeaconUseCase;
        this.sessionErrorHandler = sessionErrorHandler;
    }

    @Override
    public void start(@NotNull Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Result<Session, DataError> this_$iv = this.getSessionUseCase.start(params.getVisitId());
        boolean $i$f$onSuccess = false;
        if (this_$iv instanceof Result.Success) {
            Session session = (Session)((Result.Success)this_$iv).getData();
            boolean bl = false;
            this.onGetSession(session, params.getReason());
        }
        boolean $i$f$onError = false;
        if (this_$iv instanceof Result.Error) {
            DataError error = (DataError)((Result.Error)this_$iv).getError();
            boolean bl = false;
            DTLogger.INSTANCE.error("Error getting session " + params.getVisitId() + ": " + error);
        }
    }

    private final void onGetSession(Session session, ReasonTag reason) {
        block5: {
            Unit unit;
            Unit unit2;
            Long l = session.getLastEventTimestamp();
            if (l != null) {
                long eventTimestamp = ((Number)l).longValue();
                boolean bl = false;
                this.buildReasonBeacon(session, eventTimestamp, reason);
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            if (unit2 != null) break block5;
            SendReasonBeaconUseCase $this$onGetSession_u24lambda_u245 = this;
            boolean bl = false;
            Event event = (Event)CollectionsKt.lastOrNull($this$onGetSession_u24lambda_u245.getAllEventsByVisitIdUseCase.start(session.getVisitId()));
            if (event != null) {
                Event event2 = event;
                boolean bl2 = false;
                $this$onGetSession_u24lambda_u245.buildReasonBeacon(session, event2.getStartTime().getTime(), reason);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                SendReasonBeaconUseCase $this$onGetSession_u24lambda_u245_u24lambda_u244 = $this$onGetSession_u24lambda_u245;
                boolean bl3 = false;
                DTLogger.INSTANCE.error("No event timestamp found for session " + session.getVisitId());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildReasonBeacon(Session session, long eventTimestamp, ReasonTag reason) {
        void this_$iv;
        Result<byte[], BeaconSerializationError.BeaconSerialization> result = this.buildReasonBeaconUseCase.start(new BuildReasonBeaconUseCase.Params(this.getReasonBeaconData(session, eventTimestamp, reason)));
        boolean $i$f$onSuccess = false;
        if (this_$iv instanceof Result.Success) {
            byte[] serializedBeacon = (byte[])((Result.Success)this_$iv).getData();
            boolean bl = false;
            this.sendReasonBeacon(serializedBeacon, session.getVisitId());
        }
        boolean $i$f$onError = false;
        if (this_$iv instanceof Result.Error) {
            BeaconSerializationError.BeaconSerialization error = (BeaconSerializationError.BeaconSerialization)((Result.Error)this_$iv).getError();
            boolean bl = false;
            DTLogger.INSTANCE.error("Error building reason beacon for session " + session.getVisitId() + ": " + error);
        }
    }

    private final void sendReasonBeacon(byte[] reasonBeacon, String visitId) {
        Result<String, APIError> this_$iv = this.sendBeaconUseCase.start(new SendBeaconUseCase.Params(visitId, reasonBeacon, false, 4, null));
        boolean $i$f$onError = false;
        if (this_$iv instanceof Result.Error) {
            APIError it = (APIError)((Result.Error)this_$iv).getError();
            boolean bl = false;
            this.sessionErrorHandler.handleBeaconError("Sending reason beacon from session with visitId " + visitId, it);
        }
    }

    private final ReasonBeaconData getReasonBeaconData(Session session, long eventTimestamp, ReasonTag reason) {
        return new ReasonBeaconData(session.getVisitorId(), session.getVisitId(), eventTimestamp, eventTimestamp, reason);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SendReasonBeaconUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "visitId", "", "reason", "Lcom/dynatrace/protocols/mobile/sessionreplay/ReasonTag;", "(Ljava/lang/String;Lcom/dynatrace/protocols/mobile/sessionreplay/ReasonTag;)V", "getReason", "()Lcom/dynatrace/protocols/mobile/sessionreplay/ReasonTag;", "getVisitId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "agent_release"})
    public static final class Params
    extends UseCase.Params {
        @NotNull
        private final String visitId;
        @NotNull
        private final ReasonTag reason;

        public Params(@NotNull String visitId, @NotNull ReasonTag reason) {
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.visitId = visitId;
            this.reason = reason;
        }

        @NotNull
        public final String getVisitId() {
            return this.visitId;
        }

        @NotNull
        public final ReasonTag getReason() {
            return this.reason;
        }

        @NotNull
        public final String component1() {
            return this.visitId;
        }

        @NotNull
        public final ReasonTag component2() {
            return this.reason;
        }

        @NotNull
        public final Params copy(@NotNull String visitId, @NotNull ReasonTag reason) {
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new Params(visitId, reason);
        }

        public static /* synthetic */ Params copy$default(Params params, String string, ReasonTag reasonTag, int n, Object object) {
            if ((n & 1) != 0) {
                string = params.visitId;
            }
            if ((n & 2) != 0) {
                reasonTag = params.reason;
            }
            return params.copy(string, reasonTag);
        }

        @NotNull
        public String toString() {
            return "Params(visitId=" + this.visitId + ", reason=" + this.reason + ')';
        }

        public int hashCode() {
            int result = this.visitId.hashCode();
            result = result * 31 + this.reason.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Params)) {
                return false;
            }
            Params params = (Params)other;
            if (!Intrinsics.areEqual((Object)this.visitId, (Object)params.visitId)) {
                return false;
            }
            return this.reason == params.reason;
        }
    }
}

