/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.session;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.model.Event;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/session/LogSessionScreenshotCountUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/LogSessionScreenshotCountUseCase$Params;", "", "()V", "getLogFromVisitIdEvents", "visitId", "events", "", "Lcom/dynatrace/android/sessionreplay/model/Event;", "screenshotJobCount", "", "start", "params", "Params", "agent_release"})
@SourceDebugExtension(value={"SMAP\nLogSessionScreenshotCountUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogSessionScreenshotCountUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/session/LogSessionScreenshotCountUseCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1855#2,2:46\n*S KotlinDebug\n*F\n+ 1 LogSessionScreenshotCountUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/session/LogSessionScreenshotCountUseCase\n*L\n30#1:46,2\n*E\n"})
public final class LogSessionScreenshotCountUseCase
implements UseCase<Params, String> {
    @Override
    @NotNull
    public String start(@NotNull Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String log = this.getLogFromVisitIdEvents(params.getVisitId(), params.getEvents(), params.getScreenshotJobCount());
        DTLogger.INSTANCE.info(log);
        return log;
    }

    private final String getLogFromVisitIdEvents(String visitId, List<? extends Event> events, int screenshotJobCount) {
        if (events.isEmpty()) {
            return "Visit id " + visitId + " has no events";
        }
        int totalEvents = events.size();
        Set screenShotIds = new LinkedHashSet();
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it;
            Event event = (Event)element$iv;
            boolean bl = false;
            if (event.getScreenshotId() == null) continue;
            boolean bl2 = false;
            screenShotIds.add(it);
        }
        return "Visit id " + visitId + " total events " + totalEvents + " -> Distinct screenshotIds " + screenShotIds.size() + " created screenshot jobs " + screenshotJobCount;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/session/LogSessionScreenshotCountUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "visitId", "", "events", "", "Lcom/dynatrace/android/sessionreplay/model/Event;", "screenshotJobCount", "", "(Ljava/lang/String;Ljava/util/List;I)V", "getEvents", "()Ljava/util/List;", "getScreenshotJobCount", "()I", "getVisitId", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "agent_release"})
    public static final class Params
    extends UseCase.Params {
        @NotNull
        private final String visitId;
        @NotNull
        private final List<Event> events;
        private final int screenshotJobCount;

        public Params(@NotNull String visitId, @NotNull List<? extends Event> events, int screenshotJobCount) {
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.visitId = visitId;
            this.events = events;
            this.screenshotJobCount = screenshotJobCount;
        }

        @NotNull
        public final String getVisitId() {
            return this.visitId;
        }

        @NotNull
        public final List<Event> getEvents() {
            return this.events;
        }

        public final int getScreenshotJobCount() {
            return this.screenshotJobCount;
        }

        @NotNull
        public final String component1() {
            return this.visitId;
        }

        @NotNull
        public final List<Event> component2() {
            return this.events;
        }

        public final int component3() {
            return this.screenshotJobCount;
        }

        @NotNull
        public final Params copy(@NotNull String visitId, @NotNull List<? extends Event> events, int screenshotJobCount) {
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            Intrinsics.checkNotNullParameter(events, (String)"events");
            return new Params(visitId, events, screenshotJobCount);
        }

        public static /* synthetic */ Params copy$default(Params params, String string, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = params.visitId;
            }
            if ((n2 & 2) != 0) {
                list = params.events;
            }
            if ((n2 & 4) != 0) {
                n = params.screenshotJobCount;
            }
            return params.copy(string, list, n);
        }

        @NotNull
        public String toString() {
            return "Params(visitId=" + this.visitId + ", events=" + this.events + ", screenshotJobCount=" + this.screenshotJobCount + ')';
        }

        public int hashCode() {
            int result = this.visitId.hashCode();
            result = result * 31 + ((Object)this.events).hashCode();
            result = result * 31 + Integer.hashCode(this.screenshotJobCount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Params)) {
                return false;
            }
            Params params = (Params)other;
            if (!Intrinsics.areEqual((Object)this.visitId, (Object)params.visitId)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.events, params.events)) {
                return false;
            }
            return this.screenshotJobCount == params.screenshotJobCount;
        }
    }
}

