/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.screenshot;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.usecases.screenshot.DeleteScreenshotUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.screenshot.GetScreenshotUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.screenshot.StoreScreenshotUseCase;
import com.dynatrace.android.sessionreplay.data.screenshots.ScreenshotInfo;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.android.sessionreplay.model.ScreenshotError;
import com.dynatrace.android.sessionreplay.model.StoreScreenshotError;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ$\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J,\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u00032\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u000eH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/MoveScreenshotFromTmpUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/MoveScreenshotFromTmpUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/model/Result;", "Lcom/dynatrace/android/sessionreplay/data/screenshots/ScreenshotInfo;", "Lcom/dynatrace/android/sessionreplay/model/ScreenshotError;", "getTmpScreenshotUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/GetScreenshotUseCase;", "storeScreenshotUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/StoreScreenshotUseCase;", "deleteTmpScreenshotUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/DeleteScreenshotUseCase;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/GetScreenshotUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/StoreScreenshotUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/DeleteScreenshotUseCase;)V", "getTmpScreenshot", "", "screenshotId", "", "visitId", "start", "params", "storeScreenshot", "Lcom/dynatrace/android/sessionreplay/model/StoreScreenshotError;", "screenshotInfo", "screenshot", "Params", "agent_release"})
public final class MoveScreenshotFromTmpUseCase
implements UseCase<Params, Result<ScreenshotInfo, ScreenshotError>> {
    @NotNull
    private final GetScreenshotUseCase getTmpScreenshotUseCase;
    @NotNull
    private final StoreScreenshotUseCase storeScreenshotUseCase;
    @NotNull
    private final DeleteScreenshotUseCase deleteTmpScreenshotUseCase;

    public MoveScreenshotFromTmpUseCase(@NotNull GetScreenshotUseCase getTmpScreenshotUseCase, @NotNull StoreScreenshotUseCase storeScreenshotUseCase, @NotNull DeleteScreenshotUseCase deleteTmpScreenshotUseCase) {
        Intrinsics.checkNotNullParameter((Object)getTmpScreenshotUseCase, (String)"getTmpScreenshotUseCase");
        Intrinsics.checkNotNullParameter((Object)storeScreenshotUseCase, (String)"storeScreenshotUseCase");
        Intrinsics.checkNotNullParameter((Object)deleteTmpScreenshotUseCase, (String)"deleteTmpScreenshotUseCase");
        this.getTmpScreenshotUseCase = getTmpScreenshotUseCase;
        this.storeScreenshotUseCase = storeScreenshotUseCase;
        this.deleteTmpScreenshotUseCase = deleteTmpScreenshotUseCase;
    }

    @Override
    @NotNull
    public Result<ScreenshotInfo, ScreenshotError> start(@NotNull Params params) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Result<byte[], ScreenshotError> result2 = this.getTmpScreenshot(params.getScreenshotId(), params.getVisitId());
        if (!(result2 instanceof Result.Success)) {
            if (result2 instanceof Result.Error) {
                DTLogger.INSTANCE.warning("Error while retrieving tmp screenshot: " + ((Result.Error)result2).getError());
                return (Result)new Result.Error(((Result.Error)result2).getError());
            }
            throw new NoWhenBranchMatchedException();
        }
        byte[] tmpScreenshot = (byte[])((Result.Success)result2).getData();
        ScreenshotInfo screenshotInfo = new ScreenshotInfo(params.getScreenshotId(), (long)tmpScreenshot.length);
        Result<ScreenshotInfo, StoreScreenshotError> storeResult = this.storeScreenshot(params.getVisitId(), screenshotInfo, tmpScreenshot);
        if (storeResult instanceof Result.Success) {
            this.deleteTmpScreenshotUseCase.start(new DeleteScreenshotUseCase.Params(((ScreenshotInfo)((Result.Success)storeResult).getData()).getId()));
            result = (Result)new Result.Success((Object)screenshotInfo);
        } else if (storeResult instanceof Result.Error) {
            DTLogger.INSTANCE.warning("Error while storing screenshot: " + ((Result.Error)storeResult).getError());
            result = (Result)new Result.Error(((Result.Error)storeResult).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    private final Result<byte[], ScreenshotError> getTmpScreenshot(String screenshotId, String visitId) {
        return this.getTmpScreenshotUseCase.start(new GetScreenshotUseCase.Params(screenshotId, visitId));
    }

    private final Result<ScreenshotInfo, StoreScreenshotError> storeScreenshot(String visitId, ScreenshotInfo screenshotInfo, byte[] screenshot) {
        return this.storeScreenshotUseCase.start(new StoreScreenshotUseCase.Params(visitId, screenshotInfo, screenshot));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/MoveScreenshotFromTmpUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "visitId", "", "screenshotId", "(Ljava/lang/String;Ljava/lang/String;)V", "getScreenshotId", "()Ljava/lang/String;", "getVisitId", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "agent_release"})
    public static final class Params
    extends UseCase.Params {
        @NotNull
        private final String visitId;
        @NotNull
        private final String screenshotId;

        public Params(@NotNull String visitId, @NotNull String screenshotId) {
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            Intrinsics.checkNotNullParameter((Object)screenshotId, (String)"screenshotId");
            this.visitId = visitId;
            this.screenshotId = screenshotId;
        }

        @NotNull
        public final String getVisitId() {
            return this.visitId;
        }

        @NotNull
        public final String getScreenshotId() {
            return this.screenshotId;
        }

        @NotNull
        public final String component1() {
            return this.visitId;
        }

        @NotNull
        public final String component2() {
            return this.screenshotId;
        }

        @NotNull
        public final Params copy(@NotNull String visitId, @NotNull String screenshotId) {
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            Intrinsics.checkNotNullParameter((Object)screenshotId, (String)"screenshotId");
            return new Params(visitId, screenshotId);
        }

        public static /* synthetic */ Params copy$default(Params params, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = params.visitId;
            }
            if ((n & 2) != 0) {
                string2 = params.screenshotId;
            }
            return params.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Params(visitId=" + this.visitId + ", screenshotId=" + this.screenshotId + ')';
        }

        public int hashCode() {
            int result = this.visitId.hashCode();
            result = result * 31 + this.screenshotId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Params)) {
                return false;
            }
            Params params = (Params)other;
            if (!Intrinsics.areEqual((Object)this.visitId, (Object)params.visitId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.screenshotId, (Object)params.screenshotId);
        }
    }
}

