/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.screenshot;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.manager.SessionStopper;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.usecases.purge.PurgeScreenshotsUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.screenshot.CheckImageCanFitUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.CleanSessionUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.GetAllSessionsUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.sync.SendReasonBeaconUseCase;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.android.sessionreplay.model.Session;
import com.dynatrace.protocols.mobile.sessionreplay.ReasonTag;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u001f B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\u0015\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/FreeUpSpaceUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/FreeUpSpaceUseCase$Params;", "", "getAllSessionsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/GetAllSessionsUseCase;", "cleanSessionUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/CleanSessionUseCase;", "sessionStopper", "Lcom/dynatrace/android/sessionreplay/core/manager/SessionStopper;", "checkImageCanFitUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/CheckImageCanFitUseCase;", "purgeScreenshotsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/purge/PurgeScreenshotsUseCase;", "sendReasonBeaconUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SendReasonBeaconUseCase;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/session/GetAllSessionsUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/session/CleanSessionUseCase;Lcom/dynatrace/android/sessionreplay/core/manager/SessionStopper;Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/CheckImageCanFitUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/purge/PurgeScreenshotsUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SendReasonBeaconUseCase;)V", "cleanSessions", "", "sessions", "", "Lcom/dynatrace/android/sessionreplay/model/Session;", "getSessionsData", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/FreeUpSpaceUseCase$SessionsData;", "currentVisitId", "", "sendReasonBeacon", "visitId", "start", "params", "(Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/FreeUpSpaceUseCase$Params;)Ljava/lang/Boolean;", "Params", "SessionsData", "agent_release"})
@SourceDebugExtension(value={"SMAP\nFreeUpSpaceUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreeUpSpaceUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/screenshot/FreeUpSpaceUseCase\n+ 2 Result.kt\ncom/dynatrace/android/sessionreplay/model/Result\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n33#2,4:97\n1855#3,2:101\n1855#3,2:103\n*S KotlinDebug\n*F\n+ 1 FreeUpSpaceUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/screenshot/FreeUpSpaceUseCase\n*L\n28#1:97,4\n59#1:101,2\n69#1:103,2\n*E\n"})
public final class FreeUpSpaceUseCase
implements UseCase<Params, Boolean> {
    @NotNull
    private final GetAllSessionsUseCase getAllSessionsUseCase;
    @NotNull
    private final CleanSessionUseCase cleanSessionUseCase;
    @NotNull
    private final SessionStopper sessionStopper;
    @NotNull
    private final CheckImageCanFitUseCase checkImageCanFitUseCase;
    @NotNull
    private final PurgeScreenshotsUseCase purgeScreenshotsUseCase;
    @NotNull
    private final SendReasonBeaconUseCase sendReasonBeaconUseCase;

    public FreeUpSpaceUseCase(@NotNull GetAllSessionsUseCase getAllSessionsUseCase, @NotNull CleanSessionUseCase cleanSessionUseCase, @NotNull SessionStopper sessionStopper, @NotNull CheckImageCanFitUseCase checkImageCanFitUseCase, @NotNull PurgeScreenshotsUseCase purgeScreenshotsUseCase, @NotNull SendReasonBeaconUseCase sendReasonBeaconUseCase) {
        Intrinsics.checkNotNullParameter((Object)getAllSessionsUseCase, (String)"getAllSessionsUseCase");
        Intrinsics.checkNotNullParameter((Object)cleanSessionUseCase, (String)"cleanSessionUseCase");
        Intrinsics.checkNotNullParameter((Object)sessionStopper, (String)"sessionStopper");
        Intrinsics.checkNotNullParameter((Object)checkImageCanFitUseCase, (String)"checkImageCanFitUseCase");
        Intrinsics.checkNotNullParameter((Object)purgeScreenshotsUseCase, (String)"purgeScreenshotsUseCase");
        Intrinsics.checkNotNullParameter((Object)sendReasonBeaconUseCase, (String)"sendReasonBeaconUseCase");
        this.getAllSessionsUseCase = getAllSessionsUseCase;
        this.cleanSessionUseCase = cleanSessionUseCase;
        this.sessionStopper = sessionStopper;
        this.checkImageCanFitUseCase = checkImageCanFitUseCase;
        this.purgeScreenshotsUseCase = purgeScreenshotsUseCase;
        this.sendReasonBeaconUseCase = sendReasonBeaconUseCase;
    }

    @Override
    @NotNull
    public Boolean start(@NotNull Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        SessionsData sessionsData = this.getSessionsData(params.getVisitId());
        Session session = sessionsData.getCurrent();
        if (session != null) {
            Session current = session;
            boolean bl = false;
            DTLogger.INSTANCE.warning("Free up space -> purge screenshots");
            Result<Long, Unit> this_$iv = this.purgeScreenshotsUseCase.start();
            boolean $i$f$onSuccess = false;
            if (this_$iv instanceof Result.Success) {
                long freeSpace = ((Number)((Result.Success)this_$iv).getData()).longValue();
                boolean bl2 = false;
                if (freeSpace >= params.getFileSize()) {
                    return true;
                }
            }
            DTLogger.INSTANCE.warning("Free up space -> clean not sent & not crashed sessions");
            this.cleanSessions(sessionsData.getNoSentNoCrashed());
            if (this.checkImageCanFitUseCase.start(params.getFileSize()).booleanValue()) {
                return true;
            }
            if (!current.isPartiallySent()) {
                DTLogger.INSTANCE.warning("Free up space -> stop and clean current (not sent)");
                this.sendReasonBeacon(current.getVisitId());
                this.cleanSessionUseCase.start(current.getVisitId());
                this.sessionStopper.run(false);
                return false;
            }
            DTLogger.INSTANCE.warning("Free up space -> clean sent & not crashed sessions");
            this.cleanSessions(sessionsData.getSentNoCrashed());
            if (this.checkImageCanFitUseCase.start(params.getFileSize()).booleanValue()) {
                return true;
            }
            DTLogger.INSTANCE.warning("Free up space -> stop current sent session");
            this.sessionStopper.run(false);
            return false;
        }
        FreeUpSpaceUseCase $this$start_u24lambda_u242 = this;
        boolean bl = false;
        DTLogger.INSTANCE.error("Free up space -> must be triggered by current session");
        return false;
    }

    private final void cleanSessions(List<Session> sessions) {
        DTLogger.INSTANCE.warning("Free up space -> clean sessions: " + sessions);
        Iterable $this$forEach$iv = sessions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Session session = (Session)element$iv;
            boolean bl = false;
            this.sendReasonBeacon(session.getVisitId());
            this.cleanSessionUseCase.start(session.getVisitId());
        }
    }

    private final SessionsData getSessionsData(String currentVisitId) {
        Session currentSession = null;
        List sentSessionsNoCrashed = new ArrayList();
        List noSentSessionsNoCrashed = new ArrayList();
        Iterable $this$forEach$iv = (Iterable)this.getAllSessionsUseCase.start();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Session session = (Session)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)session.getVisitId(), (Object)currentVisitId)) {
                currentSession = session;
                continue;
            }
            if (session.isPartiallySent() && !session.getDidCrash()) {
                sentSessionsNoCrashed.add(session);
                continue;
            }
            if (session.getDidCrash()) continue;
            noSentSessionsNoCrashed.add(session);
        }
        return new SessionsData(currentSession, sentSessionsNoCrashed, noSentSessionsNoCrashed);
    }

    private final void sendReasonBeacon(String visitId) {
        this.sendReasonBeaconUseCase.start(new SendReasonBeaconUseCase.Params(visitId, ReasonTag.REASON_FULL_STORAGE));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/FreeUpSpaceUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "visitId", "", "fileSize", "", "(Ljava/lang/String;J)V", "getFileSize", "()J", "getVisitId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "agent_release"})
    public static final class Params
    extends UseCase.Params {
        @NotNull
        private final String visitId;
        private final long fileSize;

        public Params(@NotNull String visitId, long fileSize) {
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            this.visitId = visitId;
            this.fileSize = fileSize;
        }

        @NotNull
        public final String getVisitId() {
            return this.visitId;
        }

        public final long getFileSize() {
            return this.fileSize;
        }

        @NotNull
        public final String component1() {
            return this.visitId;
        }

        public final long component2() {
            return this.fileSize;
        }

        @NotNull
        public final Params copy(@NotNull String visitId, long fileSize) {
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            return new Params(visitId, fileSize);
        }

        public static /* synthetic */ Params copy$default(Params params, String string, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = params.visitId;
            }
            if ((n & 2) != 0) {
                l = params.fileSize;
            }
            return params.copy(string, l);
        }

        @NotNull
        public String toString() {
            return "Params(visitId=" + this.visitId + ", fileSize=" + this.fileSize + ')';
        }

        public int hashCode() {
            int result = this.visitId.hashCode();
            result = result * 31 + Long.hashCode(this.fileSize);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Params)) {
                return false;
            }
            Params params = (Params)other;
            if (!Intrinsics.areEqual((Object)this.visitId, (Object)params.visitId)) {
                return false;
            }
            return this.fileSize == params.fileSize;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J5\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/FreeUpSpaceUseCase$SessionsData;", "", "current", "Lcom/dynatrace/android/sessionreplay/model/Session;", "sentNoCrashed", "", "noSentNoCrashed", "(Lcom/dynatrace/android/sessionreplay/model/Session;Ljava/util/List;Ljava/util/List;)V", "getCurrent", "()Lcom/dynatrace/android/sessionreplay/model/Session;", "getNoSentNoCrashed", "()Ljava/util/List;", "getSentNoCrashed", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "agent_release"})
    private static final class SessionsData {
        @Nullable
        private final Session current;
        @NotNull
        private final List<Session> sentNoCrashed;
        @NotNull
        private final List<Session> noSentNoCrashed;

        public SessionsData(@Nullable Session current, @NotNull List<Session> sentNoCrashed, @NotNull List<Session> noSentNoCrashed) {
            Intrinsics.checkNotNullParameter(sentNoCrashed, (String)"sentNoCrashed");
            Intrinsics.checkNotNullParameter(noSentNoCrashed, (String)"noSentNoCrashed");
            this.current = current;
            this.sentNoCrashed = sentNoCrashed;
            this.noSentNoCrashed = noSentNoCrashed;
        }

        @Nullable
        public final Session getCurrent() {
            return this.current;
        }

        @NotNull
        public final List<Session> getSentNoCrashed() {
            return this.sentNoCrashed;
        }

        @NotNull
        public final List<Session> getNoSentNoCrashed() {
            return this.noSentNoCrashed;
        }

        @Nullable
        public final Session component1() {
            return this.current;
        }

        @NotNull
        public final List<Session> component2() {
            return this.sentNoCrashed;
        }

        @NotNull
        public final List<Session> component3() {
            return this.noSentNoCrashed;
        }

        @NotNull
        public final SessionsData copy(@Nullable Session current, @NotNull List<Session> sentNoCrashed, @NotNull List<Session> noSentNoCrashed) {
            Intrinsics.checkNotNullParameter(sentNoCrashed, (String)"sentNoCrashed");
            Intrinsics.checkNotNullParameter(noSentNoCrashed, (String)"noSentNoCrashed");
            return new SessionsData(current, sentNoCrashed, noSentNoCrashed);
        }

        public static /* synthetic */ SessionsData copy$default(SessionsData sessionsData, Session session, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                session = sessionsData.current;
            }
            if ((n & 2) != 0) {
                list = sessionsData.sentNoCrashed;
            }
            if ((n & 4) != 0) {
                list2 = sessionsData.noSentNoCrashed;
            }
            return sessionsData.copy(session, list, list2);
        }

        @NotNull
        public String toString() {
            return "SessionsData(current=" + this.current + ", sentNoCrashed=" + this.sentNoCrashed + ", noSentNoCrashed=" + this.noSentNoCrashed + ')';
        }

        public int hashCode() {
            int result = this.current == null ? 0 : this.current.hashCode();
            result = result * 31 + ((Object)this.sentNoCrashed).hashCode();
            result = result * 31 + ((Object)this.noSentNoCrashed).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SessionsData)) {
                return false;
            }
            SessionsData sessionsData = (SessionsData)other;
            if (!Intrinsics.areEqual((Object)this.current, (Object)sessionsData.current)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.sentNoCrashed, sessionsData.sentNoCrashed)) {
                return false;
            }
            return Intrinsics.areEqual(this.noSentNoCrashed, sessionsData.noSentNoCrashed);
        }
    }
}

