/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.event;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.usecases.event.GetAllEventsBetweenSystemTimesUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.event.UpdateRageTapTouchesUseCase;
import com.dynatrace.android.sessionreplay.model.DataError;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.Result;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0016J*\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\f\u001a\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/event/TrackRageTapUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/event/TrackRageTapUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/model/Result;", "", "Lcom/dynatrace/android/sessionreplay/model/DataError;", "getEventsBetweenSystemTimesUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/event/GetAllEventsBetweenSystemTimesUseCase;", "updateRageTapTouchesUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/event/UpdateRageTapTouchesUseCase;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/event/GetAllEventsBetweenSystemTimesUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/event/UpdateRageTapTouchesUseCase;)V", "start", "params", "updateTouches", "events", "", "Lcom/dynatrace/android/sessionreplay/model/Event;", "Params", "agent_release"})
public final class TrackRageTapUseCase
implements UseCase<Params, Result<Integer, DataError>> {
    @NotNull
    private final GetAllEventsBetweenSystemTimesUseCase getEventsBetweenSystemTimesUseCase;
    @NotNull
    private final UpdateRageTapTouchesUseCase updateRageTapTouchesUseCase;

    public TrackRageTapUseCase(@NotNull GetAllEventsBetweenSystemTimesUseCase getEventsBetweenSystemTimesUseCase, @NotNull UpdateRageTapTouchesUseCase updateRageTapTouchesUseCase) {
        Intrinsics.checkNotNullParameter((Object)getEventsBetweenSystemTimesUseCase, (String)"getEventsBetweenSystemTimesUseCase");
        Intrinsics.checkNotNullParameter((Object)updateRageTapTouchesUseCase, (String)"updateRageTapTouchesUseCase");
        this.getEventsBetweenSystemTimesUseCase = getEventsBetweenSystemTimesUseCase;
        this.updateRageTapTouchesUseCase = updateRageTapTouchesUseCase;
    }

    @Override
    @NotNull
    public Result<Integer, DataError> start(@NotNull Params params) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Result<List<Event>, Unit> result2 = this.getEventsBetweenSystemTimesUseCase.start(new GetAllEventsBetweenSystemTimesUseCase.Params(params.getSystemStartTime(), params.getSystemEndTime()));
        if (result2 instanceof Result.Success) {
            result = this.updateTouches(params, (List)((Result.Success)result2).getData());
        } else if (result2 instanceof Result.Error) {
            DTLogger.INSTANCE.error("Error getting RageTap touches");
            result = (Result)new Result.Error((Object)DataError.NotFound.INSTANCE);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    private final Result<Integer, DataError> updateTouches(Params params, List<? extends Event> events) {
        Result result;
        Result<List<Event>, DataError> resultUpdated = this.updateRageTapTouchesUseCase.start(new UpdateRageTapTouchesUseCase.Params(events));
        if (resultUpdated instanceof Result.Success) {
            int updatedEvents = ((List)((Result.Success)resultUpdated).getData()).size();
            if (updatedEvents != params.getNumOfTouches()) {
                DTLogger.INSTANCE.warning("Total RageTap touches different than total updated events");
            }
            result = (Result)new Result.Success((Object)updatedEvents);
        } else if (resultUpdated instanceof Result.Error) {
            DTLogger.INSTANCE.error("Error updating RageTap touches: " + ((Result.Error)resultUpdated).getError());
            result = (Result)new Result.Error(((Result.Error)resultUpdated).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/event/TrackRageTapUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "systemStartTime", "", "systemEndTime", "numOfTouches", "", "(JJI)V", "getNumOfTouches", "()I", "getSystemEndTime", "()J", "getSystemStartTime", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "agent_release"})
    public static final class Params
    extends UseCase.Params {
        private final long systemStartTime;
        private final long systemEndTime;
        private final int numOfTouches;

        public Params(long systemStartTime, long systemEndTime, int numOfTouches) {
            this.systemStartTime = systemStartTime;
            this.systemEndTime = systemEndTime;
            this.numOfTouches = numOfTouches;
        }

        public final long getSystemStartTime() {
            return this.systemStartTime;
        }

        public final long getSystemEndTime() {
            return this.systemEndTime;
        }

        public final int getNumOfTouches() {
            return this.numOfTouches;
        }

        public final long component1() {
            return this.systemStartTime;
        }

        public final long component2() {
            return this.systemEndTime;
        }

        public final int component3() {
            return this.numOfTouches;
        }

        @NotNull
        public final Params copy(long systemStartTime, long systemEndTime, int numOfTouches) {
            return new Params(systemStartTime, systemEndTime, numOfTouches);
        }

        public static /* synthetic */ Params copy$default(Params params, long l, long l2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = params.systemStartTime;
            }
            if ((n2 & 2) != 0) {
                l2 = params.systemEndTime;
            }
            if ((n2 & 4) != 0) {
                n = params.numOfTouches;
            }
            return params.copy(l, l2, n);
        }

        @NotNull
        public String toString() {
            return "Params(systemStartTime=" + this.systemStartTime + ", systemEndTime=" + this.systemEndTime + ", numOfTouches=" + this.numOfTouches + ')';
        }

        public int hashCode() {
            int result = Long.hashCode(this.systemStartTime);
            result = result * 31 + Long.hashCode(this.systemEndTime);
            result = result * 31 + Integer.hashCode(this.numOfTouches);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Params)) {
                return false;
            }
            Params params = (Params)other;
            if (this.systemStartTime != params.systemStartTime) {
                return false;
            }
            if (this.systemEndTime != params.systemEndTime) {
                return false;
            }
            return this.numOfTouches == params.numOfTouches;
        }
    }
}

