/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.event;

import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.usecases.log.SaveLogUseCase;
import com.dynatrace.android.sessionreplay.core.utils.ExtensionsKt;
import com.dynatrace.android.sessionreplay.data.repositories.EventRepository;
import com.dynatrace.android.sessionreplay.model.DataError;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.Result;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/event/SaveEventUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/event/SaveEventUseCase$SaveEventParams;", "Lcom/dynatrace/android/sessionreplay/model/Result;", "Lcom/dynatrace/android/sessionreplay/model/Event;", "Lcom/dynatrace/android/sessionreplay/model/DataError;", "eventRepository", "Lcom/dynatrace/android/sessionreplay/data/repositories/EventRepository;", "logUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/log/SaveLogUseCase;", "(Lcom/dynatrace/android/sessionreplay/data/repositories/EventRepository;Lcom/dynatrace/android/sessionreplay/core/usecases/log/SaveLogUseCase;)V", "start", "params", "SaveEventParams", "agent_release"})
@SourceDebugExtension(value={"SMAP\nSaveEventUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SaveEventUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/event/SaveEventUseCase\n+ 2 Result.kt\ncom/dynatrace/android/sessionreplay/model/Result\n*L\n1#1,27:1\n40#2,4:28\n*S KotlinDebug\n*F\n+ 1 SaveEventUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/event/SaveEventUseCase\n*L\n20#1:28,4\n*E\n"})
public final class SaveEventUseCase
implements UseCase<SaveEventParams, Result<Event, DataError>> {
    @NotNull
    private final EventRepository eventRepository;
    @NotNull
    private final SaveLogUseCase logUseCase;

    public SaveEventUseCase(@NotNull EventRepository eventRepository, @NotNull SaveLogUseCase logUseCase) {
        Intrinsics.checkNotNullParameter((Object)eventRepository, (String)"eventRepository");
        Intrinsics.checkNotNullParameter((Object)logUseCase, (String)"logUseCase");
        this.eventRepository = eventRepository;
        this.logUseCase = logUseCase;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result<Event, DataError> start(@NotNull SaveEventParams params) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Result this_$iv = this.eventRepository.create(params.getEvent(), params.getVisitId());
        boolean $i$f$onError = false;
        if (this_$iv instanceof Result.Error) {
            DataError error = (DataError)((Result.Error)this_$iv).getError();
            boolean bl = false;
            ExtensionsKt.logError(this.logUseCase, params.getVisitId(), "Error saving " + params.getEvent().getType() + " event: " + error);
        }
        return var2_2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/event/SaveEventUseCase$SaveEventParams;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "event", "Lcom/dynatrace/android/sessionreplay/model/Event;", "visitId", "", "(Lcom/dynatrace/android/sessionreplay/model/Event;Ljava/lang/String;)V", "getEvent", "()Lcom/dynatrace/android/sessionreplay/model/Event;", "getVisitId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "agent_release"})
    public static final class SaveEventParams
    extends UseCase.Params {
        @NotNull
        private final Event event;
        @NotNull
        private final String visitId;

        public SaveEventParams(@NotNull Event event, @NotNull String visitId) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            this.event = event;
            this.visitId = visitId;
        }

        @NotNull
        public final Event getEvent() {
            return this.event;
        }

        @NotNull
        public final String getVisitId() {
            return this.visitId;
        }

        @NotNull
        public final Event component1() {
            return this.event;
        }

        @NotNull
        public final String component2() {
            return this.visitId;
        }

        @NotNull
        public final SaveEventParams copy(@NotNull Event event, @NotNull String visitId) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            return new SaveEventParams(event, visitId);
        }

        public static /* synthetic */ SaveEventParams copy$default(SaveEventParams saveEventParams, Event event, String string, int n, Object object) {
            if ((n & 1) != 0) {
                event = saveEventParams.event;
            }
            if ((n & 2) != 0) {
                string = saveEventParams.visitId;
            }
            return saveEventParams.copy(event, string);
        }

        @NotNull
        public String toString() {
            return "SaveEventParams(event=" + this.event + ", visitId=" + this.visitId + ')';
        }

        public int hashCode() {
            int result = this.event.hashCode();
            result = result * 31 + this.visitId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SaveEventParams)) {
                return false;
            }
            SaveEventParams saveEventParams = (SaveEventParams)other;
            if (!Intrinsics.areEqual((Object)this.event, (Object)saveEventParams.event)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.visitId, (Object)saveEventParams.visitId);
        }
    }
}

