/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.event;

import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.data.repositories.EventRepository;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.Result;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u00030\u0001:\u0001\fB\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\"\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/event/GetAllEventsBetweenSystemTimesUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/event/GetAllEventsBetweenSystemTimesUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/model/Result;", "", "Lcom/dynatrace/android/sessionreplay/model/Event;", "", "eventRepository", "Lcom/dynatrace/android/sessionreplay/data/repositories/EventRepository;", "(Lcom/dynatrace/android/sessionreplay/data/repositories/EventRepository;)V", "start", "params", "Params", "agent_release"})
public final class GetAllEventsBetweenSystemTimesUseCase
implements UseCase<Params, Result<List<? extends Event>, Unit>> {
    @NotNull
    private final EventRepository eventRepository;

    public GetAllEventsBetweenSystemTimesUseCase(@NotNull EventRepository eventRepository) {
        Intrinsics.checkNotNullParameter((Object)eventRepository, (String)"eventRepository");
        this.eventRepository = eventRepository;
    }

    @Override
    @NotNull
    public Result<List<Event>, Unit> start(@NotNull Params params) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Result result2 = this.eventRepository.getBetweenSystemTimes(params.getSystemStartTime(), params.getSystemEndTime());
        if (result2 instanceof Result.Success) {
            result = (Result)new Result.Success(((Result.Success)result2).getData());
        } else if (result2 instanceof Result.Error) {
            result = (Result)new Result.Error((Object)Unit.INSTANCE);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/event/GetAllEventsBetweenSystemTimesUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "systemStartTime", "", "systemEndTime", "(JJ)V", "getSystemEndTime", "()J", "getSystemStartTime", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "agent_release"})
    public static final class Params
    extends UseCase.Params {
        private final long systemStartTime;
        private final long systemEndTime;

        public Params(long systemStartTime, long systemEndTime) {
            this.systemStartTime = systemStartTime;
            this.systemEndTime = systemEndTime;
        }

        public final long getSystemStartTime() {
            return this.systemStartTime;
        }

        public final long getSystemEndTime() {
            return this.systemEndTime;
        }

        public final long component1() {
            return this.systemStartTime;
        }

        public final long component2() {
            return this.systemEndTime;
        }

        @NotNull
        public final Params copy(long systemStartTime, long systemEndTime) {
            return new Params(systemStartTime, systemEndTime);
        }

        public static /* synthetic */ Params copy$default(Params params, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = params.systemStartTime;
            }
            if ((n & 2) != 0) {
                l2 = params.systemEndTime;
            }
            return params.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "Params(systemStartTime=" + this.systemStartTime + ", systemEndTime=" + this.systemEndTime + ')';
        }

        public int hashCode() {
            int result = Long.hashCode(this.systemStartTime);
            result = result * 31 + Long.hashCode(this.systemEndTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Params)) {
                return false;
            }
            Params params = (Params)other;
            if (this.systemStartTime != params.systemStartTime) {
                return false;
            }
            return this.systemEndTime == params.systemEndTime;
        }
    }
}

