/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.beacon;

import com.dynatrace.android.sessionreplay.core.configuration.TenantConfiguration;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.model.BeaconSerializationError;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.protocols.mobile.sessionreplay.BeaconDataType;
import com.dynatrace.protocols.mobile.sessionreplay.exceptions.InvalidSerializationDataException;
import com.dynatrace.protocols.mobile.sessionreplay.tags.TaggedBeaconBuilder;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\b\u0000\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u00030\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ4\u0010\n\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00050\u0005 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\"\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildImageBeaconsUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildImageBeaconsUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/model/Result;", "", "", "Lcom/dynatrace/android/sessionreplay/model/BeaconSerializationError$BeaconSerialization;", "tenantConfiguration", "Lcom/dynatrace/android/sessionreplay/core/configuration/TenantConfiguration;", "(Lcom/dynatrace/android/sessionreplay/core/configuration/TenantConfiguration;)V", "buildBeacons", "", "kotlin.jvm.PlatformType", "params", "start", "Params", "agent_release"})
public final class BuildImageBeaconsUseCase
implements UseCase<Params, Result<List<? extends byte[]>, BeaconSerializationError.BeaconSerialization>> {
    @NotNull
    private final TenantConfiguration tenantConfiguration;

    public BuildImageBeaconsUseCase(@NotNull TenantConfiguration tenantConfiguration) {
        Intrinsics.checkNotNullParameter((Object)tenantConfiguration, (String)"tenantConfiguration");
        this.tenantConfiguration = tenantConfiguration;
    }

    @Override
    @NotNull
    public Result<List<byte[]>, BeaconSerializationError.BeaconSerialization> start(@NotNull Params params) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        try {
            List<byte[]> list = this.buildBeacons(params);
            Intrinsics.checkNotNullExpressionValue(list, (String)"buildBeacons(...)");
            result = (Result)new Result.Success(list);
        }
        catch (InvalidSerializationDataException e) {
            result = (Result)new Result.Error((Object)BeaconSerializationError.BeaconSerialization.INSTANCE);
        }
        return result;
    }

    private final List<byte[]> buildBeacons(Params params) {
        Params $this$buildBeacons_u24lambda_u240 = params;
        boolean bl = false;
        return new TaggedBeaconBuilder().withVisitorId($this$buildBeacons_u24lambda_u240.getVisitorId()).withVisitId($this$buildBeacons_u24lambda_u240.getVisitId()).withType(BeaconDataType.IMAGE).withImageId($this$buildBeacons_u24lambda_u240.getScreenshotId()).withImage($this$buildBeacons_u24lambda_u240.getImage()).withEndTime($this$buildBeacons_u24lambda_u240.getTime()).withStartTime($this$buildBeacons_u24lambda_u240.getTime()).withMaxBeaconSizeInB(this.tenantConfiguration.getMaxBeaconSizeInBytes()).build();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildImageBeaconsUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "visitorId", "", "visitId", "image", "", "screenshotId", "time", "", "(Ljava/lang/String;Ljava/lang/String;[BLjava/lang/String;J)V", "getImage", "()[B", "getScreenshotId", "()Ljava/lang/String;", "getTime", "()J", "getVisitId", "getVisitorId", "equals", "", "other", "", "hashCode", "", "agent_release"})
    public static final class Params
    extends UseCase.Params {
        @NotNull
        private final String visitorId;
        @NotNull
        private final String visitId;
        @NotNull
        private final byte[] image;
        @NotNull
        private final String screenshotId;
        private final long time;

        public Params(@NotNull String visitorId, @NotNull String visitId, @NotNull byte[] image, @NotNull String screenshotId, long time) {
            Intrinsics.checkNotNullParameter((Object)visitorId, (String)"visitorId");
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Intrinsics.checkNotNullParameter((Object)screenshotId, (String)"screenshotId");
            this.visitorId = visitorId;
            this.visitId = visitId;
            this.image = image;
            this.screenshotId = screenshotId;
            this.time = time;
        }

        @NotNull
        public final String getVisitorId() {
            return this.visitorId;
        }

        @NotNull
        public final String getVisitId() {
            return this.visitId;
        }

        @NotNull
        public final byte[] getImage() {
            return this.image;
        }

        @NotNull
        public final String getScreenshotId() {
            return this.screenshotId;
        }

        public final long getTime() {
            return this.time;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Params ? Intrinsics.areEqual((Object)((Params)other).visitId, (Object)this.visitId) && Intrinsics.areEqual((Object)((Params)other).visitorId, (Object)this.visitorId) && Arrays.equals(((Params)other).image, this.image) && Intrinsics.areEqual((Object)((Params)other).screenshotId, (Object)this.screenshotId) && ((Params)other).time == this.time : false;
        }

        public int hashCode() {
            int result = this.visitorId.hashCode();
            result = 31 * result + this.visitId.hashCode();
            result = 31 * result + Arrays.hashCode(this.image);
            result = 31 * result + this.screenshotId.hashCode();
            result = 31 * result + Long.hashCode(this.time);
            return result;
        }
    }
}

