/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.manager;

import com.dynatrace.android.sessionreplay.core.manager.SrParamCalculator;
import com.dynatrace.android.sessionreplay.core.manager.model.SessionStateConfiguration;
import com.dynatrace.android.sessionreplay.core.utils.DiceSimulator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/dynatrace/android/sessionreplay/core/manager/SrParamCalculatorImpl;", "Lcom/dynatrace/android/sessionreplay/core/manager/SrParamCalculator;", "()V", "calculate", "", "notificationType", "Lcom/dynatrace/android/sessionreplay/core/manager/SrParamCalculator$NotificationType;", "sessionStateConfig", "Lcom/dynatrace/android/sessionreplay/core/manager/model/SessionStateConfiguration;", "calculateForFullSessionConfig", "", "sr", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "calculateForNewSession", "calculateForSessionStatusChange", "calculateUserOptedInForCrashes", "agent_release"})
public final class SrParamCalculatorImpl
implements SrParamCalculator {
    @Override
    @NotNull
    public String calculate(@NotNull SrParamCalculator.NotificationType notificationType, @NotNull SessionStateConfiguration sessionStateConfig) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)notificationType), (String)"notificationType");
        Intrinsics.checkNotNullParameter((Object)sessionStateConfig, (String)"sessionStateConfig");
        switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
            case 1: {
                string = this.calculateForNewSession(sessionStateConfig);
                break;
            }
            case 2: {
                string = this.calculateForSessionStatusChange(sessionStateConfig);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String calculateForNewSession(SessionStateConfiguration sessionStateConfig) {
        StringBuilder sr = new StringBuilder();
        boolean replayEnabled = sessionStateConfig.getCapture() || sessionStateConfig.getFullSessionConfigReceived();
        sr.append(replayEnabled ? "1" : "0");
        this.calculateUserOptedInForCrashes(sessionStateConfig, sr);
        if (sessionStateConfig.getFullSessionConfigReceived()) {
            if (sessionStateConfig.getScreenRecordOptIn()) {
                sr.append("r");
            }
            sr.append("3");
        }
        String string = sr.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String calculateForSessionStatusChange(SessionStateConfiguration sessionStateConfig) {
        StringBuilder sr = new StringBuilder();
        if (sessionStateConfig.getCapture() || sessionStateConfig.getTrafficControlPercentage() > 0 || sessionStateConfig.getCrashEnabled()) {
            sr.append(1);
        } else {
            sr.append(0);
        }
        this.calculateUserOptedInForCrashes(sessionStateConfig, sr);
        if (sessionStateConfig.getFullSessionConfigReceived()) {
            this.calculateForFullSessionConfig(sessionStateConfig, sr);
        }
        String string = sr.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void calculateUserOptedInForCrashes(SessionStateConfiguration sessionStateConfig, StringBuilder sr) {
        if (!(!sessionStateConfig.getTrimCrashOptIn() || sessionStateConfig.getFullSessionConfigReceived() && sessionStateConfig.getScreenRecordOptIn())) {
            sr.append("c");
        }
    }

    private final void calculateForFullSessionConfig(SessionStateConfiguration sessionStateConfig, StringBuilder sr) {
        if (sessionStateConfig.getScreenRecordOptIn()) {
            sr.append("r");
        }
        if (sessionStateConfig.getCrashEnabled()) {
            sr.append("k");
        }
        if (sessionStateConfig.getTrafficControlPercentage() > 0) {
            sr.append("f");
        }
        if (sessionStateConfig.getDiceResult() == DiceSimulator.DiceResult.FAILED) {
            sr.append(2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SrParamCalculator.NotificationType.values().length];
            try {
                nArray[SrParamCalculator.NotificationType.NEW_SESSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SrParamCalculator.NotificationType.STATUS_CHANGED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

