/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.manager;

import com.dynatrace.android.sessionreplay.core.manager.SessionStateCalculator;
import com.dynatrace.android.sessionreplay.core.manager.model.SessionStateConfiguration;
import com.dynatrace.android.sessionreplay.core.utils.DiceSimulator;
import com.dynatrace.android.sessionreplay.model.SessionState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/dynatrace/android/sessionreplay/core/manager/SessionStateCalculatorImpl;", "Lcom/dynatrace/android/sessionreplay/core/manager/SessionStateCalculator;", "()V", "calculate", "Lcom/dynatrace/android/sessionreplay/model/SessionState;", "configuration", "Lcom/dynatrace/android/sessionreplay/core/manager/model/SessionStateConfiguration;", "getCrashState", "getState", "isFullEnabled", "", "agent_release"})
public final class SessionStateCalculatorImpl
implements SessionStateCalculator {
    @Override
    @NotNull
    public SessionState calculate(@NotNull SessionStateConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return !configuration.getScreenRecordOptIn() && !configuration.getTrimCrashOptIn() ? SessionState.RECORDING : (this.isFullEnabled(configuration) ? SessionState.FULL : this.getState(configuration));
    }

    private final boolean isFullEnabled(SessionStateConfiguration configuration) {
        return configuration.getScreenRecordOptIn() && configuration.getDiceResult() == DiceSimulator.DiceResult.PASSED;
    }

    private final SessionState getState(SessionStateConfiguration configuration) {
        return (configuration.getCrashEnabled() || configuration.getCapture()) && configuration.getCrashReportingOptIn() ? this.getCrashState(configuration) : SessionState.RECORDING;
    }

    private final SessionState getCrashState(SessionStateConfiguration configuration) {
        return configuration.getScreenRecordOptIn() && configuration.getCrashEnabled() ? SessionState.CRASH : SessionState.TRIM_CRASH;
    }
}

