/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.manager;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Build;
import com.dynatrace.android.sessionreplay.core.connection.ConnectivityChangeBroadcastReceiver;
import com.dynatrace.android.sessionreplay.core.connection.NetworkStatus;
import com.dynatrace.android.sessionreplay.core.connection.NetworkStatusProvider;
import com.dynatrace.android.sessionreplay.core.injection.AgentInjection;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/dynatrace/android/sessionreplay/core/manager/SessionReplayServiceManager;", "", "()V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "registerNetworkObserver", "", "context", "Landroid/content/Context;", "networkStatusProvider", "Lcom/dynatrace/android/sessionreplay/core/connection/NetworkStatusProvider;", "start", "application", "Landroid/app/Application;", "agent_release"})
public final class SessionReplayServiceManager {
    @NotNull
    public static final SessionReplayServiceManager INSTANCE = new SessionReplayServiceManager();
    @NotNull
    private static final AtomicBoolean initialized = new AtomicBoolean(false);

    private SessionReplayServiceManager() {
    }

    public final synchronized void start(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        if (initialized.get()) {
            return;
        }
        Context context = application.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
        AgentInjection.Companion.init(context);
        this.registerNetworkObserver((Context)application, AgentInjection.Companion.get().getNetworkStatusProvider());
        initialized.set(true);
    }

    private final void registerNetworkObserver(Context context, NetworkStatusProvider networkStatusProvider) {
        if (Build.VERSION.SDK_INT >= 26) {
            Object object = context.getSystemService("connectivity");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
            ConnectivityManager cm = (ConnectivityManager)object;
            PackageManager packageManager = context.getPackageManager();
            Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"getPackageManager(...)");
            PackageManager pm = packageManager;
            int hasPermission = pm.checkPermission("android.permission.ACCESS_NETWORK_STATE", context.getPackageName());
            if (hasPermission == 0) {
                Network network = cm.getActiveNetwork();
                if (network == null) {
                    networkStatusProvider.setNetworkStatus(NetworkStatus.NO_CONNECTION);
                    network = Unit.INSTANCE;
                }
                cm.registerDefaultNetworkCallback(new ConnectivityManager.NetworkCallback(networkStatusProvider){
                    final /* synthetic */ NetworkStatusProvider $networkStatusProvider;
                    {
                        this.$networkStatusProvider = $networkStatusProvider;
                    }

                    public void onCapabilitiesChanged(@NotNull Network network, @NotNull NetworkCapabilities networkCapabilities) {
                        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                        Intrinsics.checkNotNullParameter((Object)networkCapabilities, (String)"networkCapabilities");
                        super.onCapabilitiesChanged(network, networkCapabilities);
                        boolean internet = networkCapabilities.hasCapability(12);
                        boolean metered = !networkCapabilities.hasCapability(11);
                        this.$networkStatusProvider.setNetworkStatus(NetworkStatus.Companion.getNetworkStatus(internet, metered));
                    }

                    public void onLost(@NotNull Network network) {
                        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                        super.onLost(network);
                        this.$networkStatusProvider.setNetworkStatus(NetworkStatus.NO_CONNECTION);
                    }
                });
            } else {
                networkStatusProvider.setNetworkStatus(NetworkStatus.Companion.getNetworkStatus(true, true));
            }
        } else {
            context.registerReceiver((BroadcastReceiver)new ConnectivityChangeBroadcastReceiver(networkStatusProvider), new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }
}

