/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.manager;

import android.app.Application;
import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import com.dynatrace.android.agent.crash.CrashCatcher;
import com.dynatrace.android.agent.crash.CrashListener;
import com.dynatrace.android.lifecycle.appstate.ApplicationStateListener;
import com.dynatrace.android.lifecycle.appstate.ApplicationStateTracker;
import com.dynatrace.android.lifecycle.callback.ActivityComponentIdentifier;
import com.dynatrace.android.lifecycle.callback.ComponentIdentifier;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.TrackingState;
import com.dynatrace.android.sessionreplay.core.configuration.ConfigurationController;
import com.dynatrace.android.sessionreplay.core.configuration.ConfigurationControllerProvider;
import com.dynatrace.android.sessionreplay.core.configuration.ConfigurationWrapper;
import com.dynatrace.android.sessionreplay.core.configuration.TransmissionMode;
import com.dynatrace.android.sessionreplay.core.configuration.masking.MaskingLevelConfig;
import com.dynatrace.android.sessionreplay.core.executor.Task;
import com.dynatrace.android.sessionreplay.core.executor.TaskKt;
import com.dynatrace.android.sessionreplay.core.executor.TaskManager;
import com.dynatrace.android.sessionreplay.core.executor.TaskManagerImpl;
import com.dynatrace.android.sessionreplay.core.injection.AgentInjection;
import com.dynatrace.android.sessionreplay.core.manager.ConfigurationHandler;
import com.dynatrace.android.sessionreplay.core.manager.ConfigurationHandlerImpl;
import com.dynatrace.android.sessionreplay.core.manager.ContextExecutor;
import com.dynatrace.android.sessionreplay.core.manager.CrashHandler;
import com.dynatrace.android.sessionreplay.core.manager.CrashHandlerImpl;
import com.dynatrace.android.sessionreplay.core.manager.DeviceResolutionProvider;
import com.dynatrace.android.sessionreplay.core.manager.DeviceResolutionProviderImpl;
import com.dynatrace.android.sessionreplay.core.manager.LifecycleHandlerKt;
import com.dynatrace.android.sessionreplay.core.manager.LifecycleStateMachine;
import com.dynatrace.android.sessionreplay.core.manager.LifecycleStateMachineBuilder;
import com.dynatrace.android.sessionreplay.core.manager.SessionReplayManager;
import com.dynatrace.android.sessionreplay.core.manager.SessionStateCalculator;
import com.dynatrace.android.sessionreplay.core.manager.SessionStateCalculatorImpl;
import com.dynatrace.android.sessionreplay.core.manager.SrParamCalculator;
import com.dynatrace.android.sessionreplay.core.manager.SrParamCalculatorImpl;
import com.dynatrace.android.sessionreplay.core.manager.listeners.SessionReplayCrashListener;
import com.dynatrace.android.sessionreplay.core.manager.model.SessionStateConfiguration;
import com.dynatrace.android.sessionreplay.core.observer.EventsObserver;
import com.dynatrace.android.sessionreplay.core.observer.TrackingObserverProvider;
import com.dynatrace.android.sessionreplay.core.scheduler.SyncSchedulerCoroutines;
import com.dynatrace.android.sessionreplay.core.usecases.configuration.SaveAgentConfigurationUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.configuration.SaveTransmissionModeUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.event.TrackRageTapUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.log.SaveLogUseCase;
import com.dynatrace.android.sessionreplay.core.utils.DiceSimulatorImpl;
import com.dynatrace.android.sessionreplay.core.utils.UtilsKt;
import com.dynatrace.android.sessionreplay.data.screenshots.ScreenshotInfoHelper;
import com.dynatrace.android.sessionreplay.data.screenshots.hashing.ByteArrayHasher;
import com.dynatrace.android.sessionreplay.data.screenshots.hashing.MD5ByteArrayHasher;
import com.dynatrace.android.sessionreplay.model.Log;
import com.dynatrace.android.sessionreplay.tracking.TrackingManager;
import com.dynatrace.android.sessionreplay.tracking.configuration.NativeMaskingConfigurationProvider;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00dd\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u00012\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u001c\u0010,\u001a\u00020)2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020)0.H\u0016J\"\u0010/\u001a\u00020)2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020)00H\u0016J\r\u00101\u001a\u000202H\u0002\u00a2\u0006\u0002\u00103J\u001e\u00104\u001a\u00020)2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\u0006\u00108\u001a\u000209J\b\u0010:\u001a\u00020)H\u0002J\u0018\u0010;\u001a\u00020)2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020)2\u0006\u0010A\u001a\u00020BH\u0002J\b\u0010C\u001a\u00020)H\u0002J\u0010\u0010D\u001a\u00020)2\u0006\u0010E\u001a\u00020FH\u0002J\u0015\u0010G\u001a\u00020)2\u0006\u0010H\u001a\u00020BH\u0000\u00a2\u0006\u0002\bIJ\u000e\u0010J\u001a\u00020)2\u0006\u0010K\u001a\u00020LJ\u0015\u0010M\u001a\u00020)2\u0006\u0010H\u001a\u00020BH\u0000\u00a2\u0006\u0002\bNJ\u000e\u0010O\u001a\u00020)2\u0006\u0010P\u001a\u00020QJ\u0016\u0010R\u001a\u00020)2\u0006\u0010S\u001a\u00020F2\u0006\u0010T\u001a\u00020UJ\u0018\u0010R\u001a\u00020)2\u0006\u0010S\u001a\u00020F2\b\u0010V\u001a\u0004\u0018\u00010WJ\u0010\u0010X\u001a\u00020)2\u0006\u0010>\u001a\u00020?H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/dynatrace/android/sessionreplay/core/manager/SessionReplayManager;", "Lcom/dynatrace/android/sessionreplay/core/manager/ContextExecutor;", "Lkotlinx/coroutines/CoroutineScope;", "()V", "appContext", "Landroid/content/Context;", "applicationStateTracker", "Lcom/dynatrace/android/lifecycle/appstate/ApplicationStateTracker;", "configControllerProvider", "Lcom/dynatrace/android/sessionreplay/core/configuration/ConfigurationControllerProvider;", "configHandler", "Lcom/dynatrace/android/sessionreplay/core/manager/ConfigurationHandler;", "getConfigHandler$agent_release", "()Lcom/dynatrace/android/sessionreplay/core/manager/ConfigurationHandler;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "crashHandler", "Lcom/dynatrace/android/sessionreplay/core/manager/CrashHandler;", "crashListener", "Lcom/dynatrace/android/agent/crash/CrashListener;", "deviceResolutionProvider", "Lcom/dynatrace/android/sessionreplay/core/manager/DeviceResolutionProvider;", "lifecycleHandler", "Lcom/dynatrace/android/sessionreplay/core/manager/LifecycleStateMachine;", "getLifecycleHandler$agent_release", "()Lcom/dynatrace/android/sessionreplay/core/manager/LifecycleStateMachine;", "sessionStateCalculator", "Lcom/dynatrace/android/sessionreplay/core/manager/SessionStateCalculator;", "srParamCalculator", "Lcom/dynatrace/android/sessionreplay/core/manager/SrParamCalculator;", "syncScheduler", "Lcom/dynatrace/android/sessionreplay/core/scheduler/SyncSchedulerCoroutines;", "taskManager", "Lcom/dynatrace/android/sessionreplay/core/executor/TaskManager;", "trackingObserverProvider", "Lcom/dynatrace/android/sessionreplay/core/observer/TrackingObserverProvider;", "trackingState", "Lcom/dynatrace/android/sessionreplay/core/TrackingState;", "enqueueTask", "", "task", "Lcom/dynatrace/android/sessionreplay/core/executor/Task;", "execute", "block", "Lkotlin/Function1;", "executeWithCoroutine", "Lkotlin/Function2;", "getAppStateListener", "com/dynatrace/android/sessionreplay/core/manager/SessionReplayManager$getAppStateListener$1", "()Lcom/dynatrace/android/sessionreplay/core/manager/SessionReplayManager$getAppStateListener$1;", "onRageTap", "startTime", "", "endTime", "numOfTouches", "", "onRecord", "onStart", "application", "Landroid/app/Application;", "config", "Lcom/dynatrace/android/sessionreplay/core/configuration/ConfigurationWrapper;", "onStop", "forceDelete", "", "processCustomEventOnBackground", "sendSessionLog", "logMessage", "", "setColorMasking", "enabled", "setColorMasking$agent_release", "setMaskingConfiguration", "maskingLevelConfig", "Lcom/dynatrace/android/sessionreplay/core/configuration/masking/MaskingLevelConfig;", "setPixelCopyEnabled", "setPixelCopyEnabled$agent_release", "setTransmissionMode", "transmissionMode", "Lcom/dynatrace/android/sessionreplay/core/configuration/TransmissionMode;", "trackCustomEvent", "name", "rect", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "updateAgentConfig", "agent_release"})
public final class SessionReplayManager
implements ContextExecutor,
CoroutineScope {
    @NotNull
    public static final SessionReplayManager INSTANCE = new SessionReplayManager();
    private static Context appContext;
    private static CrashListener crashListener;
    @NotNull
    private static final TaskManager taskManager;
    @NotNull
    private static final TrackingState trackingState;
    @NotNull
    private static final SyncSchedulerCoroutines syncScheduler;
    @NotNull
    private static final ConfigurationControllerProvider configControllerProvider;
    @NotNull
    private static final TrackingObserverProvider trackingObserverProvider;
    @NotNull
    private static final CrashHandler crashHandler;
    @NotNull
    private static final DeviceResolutionProvider deviceResolutionProvider;
    @NotNull
    private static final SessionStateCalculator sessionStateCalculator;
    @NotNull
    private static final SrParamCalculator srParamCalculator;
    @NotNull
    private static final ApplicationStateTracker applicationStateTracker;
    @NotNull
    private static final ConfigurationHandler configHandler;
    @NotNull
    private static final LifecycleStateMachine lifecycleHandler;

    private SessionReplayManager() {
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return Dispatchers.getIO().plus((CoroutineContext)JobKt.Job$default(null, (int)1, null));
    }

    @NotNull
    public final ConfigurationHandler getConfigHandler$agent_release() {
        return configHandler;
    }

    @NotNull
    public final LifecycleStateMachine getLifecycleHandler$agent_release() {
        return lifecycleHandler;
    }

    public final void setPixelCopyEnabled$agent_release(boolean enabled) {
        TrackingManager.INSTANCE.getConfigurationApi().setPixelCopyEnabled(enabled);
    }

    public final void setColorMasking$agent_release(boolean enabled) {
        TrackingManager.INSTANCE.getConfigurationApi().setColorMaskingEnabled(enabled);
    }

    public final void setMaskingConfiguration(@NotNull MaskingLevelConfig maskingLevelConfig) {
        Intrinsics.checkNotNullParameter((Object)maskingLevelConfig, (String)"maskingLevelConfig");
        TrackingManager.INSTANCE.getConfigurationApi().setNativeMaskingConfigProvider((NativeMaskingConfigurationProvider)maskingLevelConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTransmissionMode(@NotNull TransmissionMode transmissionMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)transmissionMode), (String)"transmissionMode");
        LifecycleStateMachine lifecycleStateMachine = lifecycleHandler;
        synchronized (lifecycleStateMachine) {
            boolean bl = false;
            if (!lifecycleHandler.isStarted()) {
                return;
            }
            INSTANCE.enqueueTask(TaskKt.saveTransmissionModeTask(new SaveTransmissionModeUseCase.Params(transmissionMode)));
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void trackCustomEvent(@NotNull String name, @Nullable View view) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (UtilsKt.isMainThread()) {
            if (view == null) {
                TrackingManager.INSTANCE.getTrackingApi().trackCustomFull(name);
            } else {
                TrackingManager.INSTANCE.getTrackingApi().trackCustomPartial(name, view);
            }
        } else {
            this.processCustomEventOnBackground();
        }
    }

    public final void trackCustomEvent(@NotNull String name, @NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        if (UtilsKt.isMainThread()) {
            TrackingManager.INSTANCE.getTrackingApi().trackCustomArea(name, rect);
        } else {
            this.processCustomEventOnBackground();
        }
    }

    private final void processCustomEventOnBackground() {
        String error = "Trying to track custom event in a background thread";
        DTLogger.INSTANCE.warning(error);
        this.sendSessionLog(error);
    }

    @Override
    public void execute(@NotNull Function1<? super Context, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (appContext != null) {
            Context context = appContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
                context = null;
            }
            block.invoke((Object)context);
        }
    }

    @Override
    public void executeWithCoroutine(@NotNull Function2<? super Context, ? super CoroutineScope, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (appContext != null) {
            Context context = appContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
                context = null;
            }
            block.invoke((Object)context, (Object)this);
        }
    }

    private final void onStart(Application application, ConfigurationWrapper config) {
        Context context = application.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
        appContext = context;
        Context context2 = appContext;
        if (context2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
            context2 = null;
        }
        AgentInjection.Companion.init(context2);
        this.updateAgentConfig(config);
        ConfigurationController configController = new ConfigurationController((Context)application);
        configControllerProvider.setConfigurationController(configController);
        applicationStateTracker.registerAppStateListener((ApplicationStateListener)this.getAppStateListener());
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)applicationStateTracker);
        trackingObserverProvider.setTrackingObserver(new EventsObserver(this, trackingState, taskManager, new ScreenshotInfoHelper((ByteArrayHasher)new MD5ByteArrayHasher()), AgentInjection.Companion.get().getDataAccessUseCaseFactory().getSaveTmpScreenshotUseCase(), null, 32, null));
        crashListener = new SessionReplayCrashListener(crashHandler);
        TrackingManager.INSTANCE.init(application);
        DTLogger.INSTANCE.info("Session replay agent started.");
    }

    private final getAppStateListener.1 getAppStateListener() {
        return new ApplicationStateListener(){

            public void onForeground() {
                SessionReplayManager.access$getSyncScheduler$p().start();
            }

            public void onBackground() {
                SessionReplayManager.access$enqueueTask(SessionReplayManager.INSTANCE, TaskKt.appBackgroundedFlowTask());
                SessionReplayManager.access$getSyncScheduler$p().stop();
            }
        };
    }

    private final void onRecord() {
        TrackingManager.INSTANCE.subscribe(trackingObserverProvider.getTrackingObserver());
        CrashListener crashListener = SessionReplayManager.crashListener;
        if (crashListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"crashListener");
            crashListener = null;
        }
        CrashCatcher.registerUncaughtExceptionListener((CrashListener)crashListener);
        DTLogger.INSTANCE.info("Session replay agent working.");
    }

    private final void onStop(boolean forceDelete) {
        TrackingManager.INSTANCE.unsubscribe();
        CrashListener crashListener = SessionReplayManager.crashListener;
        if (crashListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"crashListener");
            crashListener = null;
        }
        CrashCatcher.unregisterUncaughtExceptionListener((CrashListener)crashListener);
        String string = trackingState.getCurrentVisitId();
        if (string != null) {
            String visitId = string;
            boolean bl = false;
            INSTANCE.enqueueTask(TaskKt.stopFlowTask(visitId, forceDelete));
            trackingState.setCurrentVisitId(null);
        }
        DTLogger.INSTANCE.info("Session replay agent stopped.");
    }

    private final void updateAgentConfig(ConfigurationWrapper config) {
        DTLogger.INSTANCE.enableLogs(config.getLoggingEnabled());
        this.enqueueTask(TaskKt.saveAgentConfigTask(new SaveAgentConfigurationUseCase.Params(config.getAppId(), config.getBeaconUrl(), config.getLoggingEnabled(), config.getCertificateValidation())));
    }

    private final void sendSessionLog(String logMessage) {
        block0: {
            String string = trackingState.getCurrentVisitId();
            if (string == null) break block0;
            String visitId = string;
            boolean bl = false;
            Log log = new Log(visitId, logMessage, 0L, null, 12, null);
            INSTANCE.enqueueTask(TaskKt.saveLogTask(new SaveLogUseCase.Params(log)));
        }
    }

    private final void enqueueTask(Task task) {
        this.execute((Function1<? super Context, Unit>)((Function1)new Function1<Context, Unit>(task){
            final /* synthetic */ Task $task;
            {
                this.$task = $task;
                super(1);
            }

            public final void invoke(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                SessionReplayManager.access$getTaskManager$p().enqueueTask(context, this.$task);
            }
        }));
    }

    public final void onRageTap(long startTime, long endTime, int numOfTouches) {
        this.enqueueTask(TaskKt.trackRageTap(new TrackRageTapUseCase.Params(startTime, endTime, numOfTouches)));
    }

    public static final /* synthetic */ SyncSchedulerCoroutines access$getSyncScheduler$p() {
        return syncScheduler;
    }

    public static final /* synthetic */ void access$enqueueTask(SessionReplayManager $this, Task task) {
        $this.enqueueTask(task);
    }

    public static final /* synthetic */ TaskManager access$getTaskManager$p() {
        return taskManager;
    }

    public static final /* synthetic */ void access$onStart(SessionReplayManager $this, Application application, ConfigurationWrapper config) {
        $this.onStart(application, config);
    }

    public static final /* synthetic */ void access$onRecord(SessionReplayManager $this) {
        $this.onRecord();
    }

    public static final /* synthetic */ void access$onStop(SessionReplayManager $this, boolean forceDelete) {
        $this.onStop(forceDelete);
    }

    static {
        taskManager = new TaskManagerImpl();
        trackingState = new TrackingState();
        syncScheduler = new SyncSchedulerCoroutines(INSTANCE, taskManager, trackingState);
        configControllerProvider = new ConfigurationControllerProvider();
        trackingObserverProvider = new TrackingObserverProvider();
        crashHandler = new CrashHandlerImpl(INSTANCE, trackingState, taskManager);
        deviceResolutionProvider = new DeviceResolutionProviderImpl();
        sessionStateCalculator = new SessionStateCalculatorImpl();
        srParamCalculator = new SrParamCalculatorImpl();
        applicationStateTracker = new ApplicationStateTracker((ComponentIdentifier)new ActivityComponentIdentifier());
        configHandler = new ConfigurationHandlerImpl(INSTANCE, trackingState, taskManager, deviceResolutionProvider, new SessionStateConfiguration.Builder(new DiceSimulatorImpl()), sessionStateCalculator, srParamCalculator);
        lifecycleHandler = LifecycleHandlerKt.lifecycleStateMachine((Function1<? super LifecycleStateMachineBuilder, Unit>)((Function1)lifecycleHandler.1.INSTANCE));
    }
}

