/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.manager;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.manager.RetryManager;
import com.dynatrace.android.sessionreplay.core.manager.SessionErrorHandler;
import com.dynatrace.android.sessionreplay.core.manager.SessionStopper;
import com.dynatrace.android.sessionreplay.core.usecases.beacon.model.BeaconResult;
import com.dynatrace.android.sessionreplay.core.usecases.sync.DeleteAllSyncDataUseCase;
import com.dynatrace.android.sessionreplay.model.APIError;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/dynatrace/android/sessionreplay/core/manager/SessionErrorHandlerImpl;", "Lcom/dynatrace/android/sessionreplay/core/manager/SessionErrorHandler;", "deleteAllSyncDataUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/sync/DeleteAllSyncDataUseCase;", "sessionStopper", "Lcom/dynatrace/android/sessionreplay/core/manager/SessionStopper;", "retryManager", "Lcom/dynatrace/android/sessionreplay/core/manager/RetryManager;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/sync/DeleteAllSyncDataUseCase;Lcom/dynatrace/android/sessionreplay/core/manager/SessionStopper;Lcom/dynatrace/android/sessionreplay/core/manager/RetryManager;)V", "onMaxRetries", "Lkotlin/Function0;", "", "onRetry", "result", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/model/BeaconResult;", "handleBeaconError", "sendDescriptor", "", "apiError", "Lcom/dynatrace/android/sessionreplay/model/APIError;", "agent_release"})
public final class SessionErrorHandlerImpl
implements SessionErrorHandler {
    @NotNull
    private final DeleteAllSyncDataUseCase deleteAllSyncDataUseCase;
    @NotNull
    private final SessionStopper sessionStopper;
    @NotNull
    private final RetryManager retryManager;
    @NotNull
    private BeaconResult result;
    @NotNull
    private final Function0<Unit> onMaxRetries;
    @NotNull
    private final Function0<Unit> onRetry;

    public SessionErrorHandlerImpl(@NotNull DeleteAllSyncDataUseCase deleteAllSyncDataUseCase, @NotNull SessionStopper sessionStopper, @NotNull RetryManager retryManager) {
        Intrinsics.checkNotNullParameter((Object)deleteAllSyncDataUseCase, (String)"deleteAllSyncDataUseCase");
        Intrinsics.checkNotNullParameter((Object)sessionStopper, (String)"sessionStopper");
        Intrinsics.checkNotNullParameter((Object)retryManager, (String)"retryManager");
        this.deleteAllSyncDataUseCase = deleteAllSyncDataUseCase;
        this.sessionStopper = sessionStopper;
        this.retryManager = retryManager;
        this.result = BeaconResult.NETWORK_ERROR;
        this.onMaxRetries = (Function0)new Function0<Unit>(this){
            final /* synthetic */ SessionErrorHandlerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                SessionErrorHandlerImpl.access$getDeleteAllSyncDataUseCase$p(this.this$0).start();
                SessionErrorHandlerImpl.access$getSessionStopper$p(this.this$0).run(true);
                SessionErrorHandlerImpl.access$setResult$p(this.this$0, BeaconResult.STOP_ERROR);
            }
        };
        this.onRetry = (Function0)new Function0<Unit>(this){
            final /* synthetic */ SessionErrorHandlerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                SessionErrorHandlerImpl.access$setResult$p(this.this$0, BeaconResult.STOP_ERROR);
            }
        };
    }

    @Override
    @NotNull
    public BeaconResult handleBeaconError(@NotNull String sendDescriptor, @NotNull APIError apiError) {
        Intrinsics.checkNotNullParameter((Object)sendDescriptor, (String)"sendDescriptor");
        Intrinsics.checkNotNullParameter((Object)apiError, (String)"apiError");
        this.result = BeaconResult.NETWORK_ERROR;
        APIError aPIError = apiError;
        if (aPIError instanceof APIError.GenericServerError) {
            DTLogger.INSTANCE.error("Server error " + sendDescriptor + ": " + ((APIError.GenericServerError)apiError).getStatusCode());
            this.retryManager.manageRetry(this.onMaxRetries, this.onRetry);
        } else if (aPIError instanceof APIError.NetworkError) {
            DTLogger.INSTANCE.error("Network error " + sendDescriptor);
        } else if (aPIError instanceof APIError.InvalidParameter) {
            DTLogger.INSTANCE.error("Invalid parameter " + sendDescriptor + ": " + ((APIError.InvalidParameter)apiError).getMessage());
        } else if (aPIError instanceof APIError.EmergencyStop) {
            DTLogger.INSTANCE.error("Emergency stop " + sendDescriptor);
            this.deleteAllSyncDataUseCase.start();
            this.sessionStopper.run(true);
            this.result = BeaconResult.STOP_ERROR;
        } else if (aPIError instanceof APIError.InvalidResponseFormat) {
            DTLogger.INSTANCE.error("Invalid response format " + sendDescriptor);
            this.retryManager.manageRetry(this.onMaxRetries, this.onRetry);
        } else if (aPIError instanceof APIError.ResponseStatusError) {
            DTLogger.INSTANCE.error("Response 200 with status ERROR " + sendDescriptor);
            this.retryManager.manageRetry(this.onMaxRetries, this.onRetry);
        }
        return this.result;
    }

    public static final /* synthetic */ DeleteAllSyncDataUseCase access$getDeleteAllSyncDataUseCase$p(SessionErrorHandlerImpl $this) {
        return $this.deleteAllSyncDataUseCase;
    }

    public static final /* synthetic */ SessionStopper access$getSessionStopper$p(SessionErrorHandlerImpl $this) {
        return $this.sessionStopper;
    }

    public static final /* synthetic */ void access$setResult$p(SessionErrorHandlerImpl $this, BeaconResult beaconResult) {
        $this.result = beaconResult;
    }
}

