/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.manager;

import android.content.Context;
import com.dynatrace.android.agent.conf.ReplayConfiguration;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.TrackingState;
import com.dynatrace.android.sessionreplay.core.VisitIdHelper;
import com.dynatrace.android.sessionreplay.core.executor.TaskKt;
import com.dynatrace.android.sessionreplay.core.executor.TaskManager;
import com.dynatrace.android.sessionreplay.core.manager.ConfigurationHandler;
import com.dynatrace.android.sessionreplay.core.manager.ContextExecutor;
import com.dynatrace.android.sessionreplay.core.manager.DeviceResolutionProvider;
import com.dynatrace.android.sessionreplay.core.manager.SessionReplayManager;
import com.dynatrace.android.sessionreplay.core.manager.SessionStateCalculator;
import com.dynatrace.android.sessionreplay.core.manager.SrParamCalculator;
import com.dynatrace.android.sessionreplay.core.manager.model.DeviceResolution;
import com.dynatrace.android.sessionreplay.core.manager.model.ReplayServerConfig;
import com.dynatrace.android.sessionreplay.core.manager.model.SessionStateConfiguration;
import com.dynatrace.android.sessionreplay.core.usecases.configuration.SaveServerConfigurationUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.configuration.SaveServerIdUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.UpdateSessionStateUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.UpdateSessionVisitIdUseCase;
import com.dynatrace.android.sessionreplay.model.SessionState;
import com.dynatrace.android.sessionreplay.tracking.TrackingManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J>\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00160\u001fH\u0016J/\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002\u00a2\u0006\u0002\u0010*J\u001c\u0010+\u001a\u00020\u00142\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\u0006\u0010,\u001a\u00020-H\u0002J\u0014\u0010.\u001a\u00020/2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0016J'\u00100\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016\u00a2\u0006\u0002\u00101J\u0010\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u0012H\u0016J\u0010\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u00162\u0006\u00108\u001a\u00020)H\u0016J'\u00109\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016\u00a2\u0006\u0002\u00101R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/dynatrace/android/sessionreplay/core/manager/ConfigurationHandlerImpl;", "Lcom/dynatrace/android/sessionreplay/core/manager/ConfigurationHandler;", "contextExecutor", "Lcom/dynatrace/android/sessionreplay/core/manager/ContextExecutor;", "trackingState", "Lcom/dynatrace/android/sessionreplay/core/TrackingState;", "taskManager", "Lcom/dynatrace/android/sessionreplay/core/executor/TaskManager;", "deviceResolutionProvider", "Lcom/dynatrace/android/sessionreplay/core/manager/DeviceResolutionProvider;", "sessionStateConfigurationBuilder", "Lcom/dynatrace/android/sessionreplay/core/manager/model/SessionStateConfiguration$Builder;", "sessionStateCalculator", "Lcom/dynatrace/android/sessionreplay/core/manager/SessionStateCalculator;", "srParamCalculator", "Lcom/dynatrace/android/sessionreplay/core/manager/SrParamCalculator;", "(Lcom/dynatrace/android/sessionreplay/core/manager/ContextExecutor;Lcom/dynatrace/android/sessionreplay/core/TrackingState;Lcom/dynatrace/android/sessionreplay/core/executor/TaskManager;Lcom/dynatrace/android/sessionreplay/core/manager/DeviceResolutionProvider;Lcom/dynatrace/android/sessionreplay/core/manager/model/SessionStateConfiguration$Builder;Lcom/dynatrace/android/sessionreplay/core/manager/SessionStateCalculator;Lcom/dynatrace/android/sessionreplay/core/manager/SrParamCalculator;)V", "calculateSessionState", "Lcom/dynatrace/android/sessionreplay/model/SessionState;", "sessionStateConfig", "Lcom/dynatrace/android/sessionreplay/core/manager/model/SessionStateConfiguration;", "calculateSrParameter", "", "notificationType", "Lcom/dynatrace/android/sessionreplay/core/manager/SrParamCalculator$NotificationType;", "serverConfiguration", "Lcom/dynatrace/android/agent/conf/ServerConfiguration;", "rumSession", "Lcom/dynatrace/android/agent/data/Session;", "Lcom/dynatrace/android/sessionreplay/core/manager/model/RumSession;", "onFinish", "Lkotlin/Function2;", "", "createNewSession", "Lcom/dynatrace/android/sessionreplay/model/Session;", "visitorId", "", "sessionId", "deviceResolution", "Lcom/dynatrace/android/sessionreplay/core/manager/model/DeviceResolution;", "sequenceNumber", "", "(JJLcom/dynatrace/android/sessionreplay/core/manager/model/DeviceResolution;Ljava/lang/Integer;)Lcom/dynatrace/android/sessionreplay/model/Session;", "generateSessionStateConfig", "replayConfig", "Lcom/dynatrace/android/agent/conf/ReplayConfiguration;", "isCurrentSession", "", "startSession", "(JJLjava/lang/Integer;)V", "updateCurrentSessionState", "sessionState", "updateServerConfiguration", "replayServerConfig", "Lcom/dynatrace/android/sessionreplay/core/manager/model/ReplayServerConfig;", "updateServerId", "serverId", "updateVisitId", "agent_release"})
public final class ConfigurationHandlerImpl
implements ConfigurationHandler {
    @NotNull
    private final ContextExecutor contextExecutor;
    @NotNull
    private final TrackingState trackingState;
    @NotNull
    private final TaskManager taskManager;
    @NotNull
    private final DeviceResolutionProvider deviceResolutionProvider;
    @NotNull
    private final SessionStateConfiguration.Builder sessionStateConfigurationBuilder;
    @NotNull
    private final SessionStateCalculator sessionStateCalculator;
    @NotNull
    private final SrParamCalculator srParamCalculator;

    public ConfigurationHandlerImpl(@NotNull ContextExecutor contextExecutor, @NotNull TrackingState trackingState, @NotNull TaskManager taskManager, @NotNull DeviceResolutionProvider deviceResolutionProvider, @NotNull SessionStateConfiguration.Builder sessionStateConfigurationBuilder, @NotNull SessionStateCalculator sessionStateCalculator, @NotNull SrParamCalculator srParamCalculator) {
        Intrinsics.checkNotNullParameter((Object)contextExecutor, (String)"contextExecutor");
        Intrinsics.checkNotNullParameter((Object)trackingState, (String)"trackingState");
        Intrinsics.checkNotNullParameter((Object)taskManager, (String)"taskManager");
        Intrinsics.checkNotNullParameter((Object)deviceResolutionProvider, (String)"deviceResolutionProvider");
        Intrinsics.checkNotNullParameter((Object)sessionStateConfigurationBuilder, (String)"sessionStateConfigurationBuilder");
        Intrinsics.checkNotNullParameter((Object)sessionStateCalculator, (String)"sessionStateCalculator");
        Intrinsics.checkNotNullParameter((Object)srParamCalculator, (String)"srParamCalculator");
        this.contextExecutor = contextExecutor;
        this.trackingState = trackingState;
        this.taskManager = taskManager;
        this.deviceResolutionProvider = deviceResolutionProvider;
        this.sessionStateConfigurationBuilder = sessionStateConfigurationBuilder;
        this.sessionStateCalculator = sessionStateCalculator;
        this.srParamCalculator = srParamCalculator;
    }

    @Override
    public void startSession(long visitorId, long sessionId, @Nullable Integer sequenceNumber) {
        this.contextExecutor.execute((Function1<? super Context, Unit>)((Function1)new Function1<Context, Unit>(this, visitorId, sessionId, sequenceNumber){
            final /* synthetic */ ConfigurationHandlerImpl this$0;
            final /* synthetic */ long $visitorId;
            final /* synthetic */ long $sessionId;
            final /* synthetic */ Integer $sequenceNumber;
            {
                this.this$0 = $receiver;
                this.$visitorId = $visitorId;
                this.$sessionId = $sessionId;
                this.$sequenceNumber = $sequenceNumber;
                super(1);
            }

            public final void invoke(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                ConfigurationHandlerImpl.access$getTaskManager$p(this.this$0).enqueueTask(context, TaskKt.resetEmergencyStopStatusTask());
                DeviceResolution deviceResolution = ConfigurationHandlerImpl.access$getDeviceResolutionProvider$p(this.this$0).getDeviceResolution(context);
                com.dynatrace.android.sessionreplay.model.Session session = ConfigurationHandlerImpl.access$createNewSession(this.this$0, this.$visitorId, this.$sessionId, deviceResolution, this.$sequenceNumber);
                ConfigurationHandlerImpl.access$getTaskManager$p(this.this$0).enqueueTask(context, TaskKt.newSessionFlowTask(session));
                TrackingManager.INSTANCE.getTrackingApi().trackGenericEvent("GENERIC_START_SESSION", false);
            }
        }));
    }

    @Override
    public boolean isCurrentSession(@NotNull Session rumSession) {
        Intrinsics.checkNotNullParameter((Object)rumSession, (String)"rumSession");
        VisitIdHelper visitIdHelper = new VisitIdHelper(rumSession.visitorId, rumSession.sessionId, rumSession.sequenceNumber);
        return Intrinsics.areEqual((Object)visitIdHelper.getVisitId(), (Object)this.trackingState.getCurrentVisitId());
    }

    @Override
    public void updateCurrentSessionState(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        this.contextExecutor.execute((Function1<? super Context, Unit>)((Function1)new Function1<Context, Unit>(this, sessionState){
            final /* synthetic */ ConfigurationHandlerImpl this$0;
            final /* synthetic */ SessionState $sessionState;
            {
                this.this$0 = $receiver;
                this.$sessionState = $sessionState;
                super(1);
            }

            public final void invoke(@NotNull Context context) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    String string = ConfigurationHandlerImpl.access$getTrackingState$p(this.this$0).getCurrentVisitId();
                    if (string == null) break block0;
                    String string2 = string;
                    ConfigurationHandlerImpl configurationHandlerImpl = this.this$0;
                    SessionState sessionState = this.$sessionState;
                    String it = string2;
                    boolean bl = false;
                    ConfigurationHandlerImpl.access$getTaskManager$p(configurationHandlerImpl).enqueueTask(context, TaskKt.updateSessionStateTask(new UpdateSessionStateUseCase.Params(it, sessionState)));
                }
            }
        }));
    }

    @Override
    @NotNull
    public SessionState calculateSessionState(@NotNull SessionStateConfiguration sessionStateConfig) {
        Intrinsics.checkNotNullParameter((Object)sessionStateConfig, (String)"sessionStateConfig");
        return this.sessionStateCalculator.calculate(sessionStateConfig);
    }

    private final com.dynatrace.android.sessionreplay.model.Session createNewSession(long visitorId, long sessionId, DeviceResolution deviceResolution, Integer sequenceNumber) {
        VisitIdHelper visitId = new VisitIdHelper(visitorId, sessionId, sequenceNumber);
        com.dynatrace.android.sessionreplay.model.Session session = new com.dynatrace.android.sessionreplay.model.Session(visitId.getStrVisitorId(), visitId.getVisitId(), deviceResolution.getHeight(), deviceResolution.getWidth(), false, false, null, SessionState.RECORDING, 112, null);
        this.trackingState.setCurrentVisitId(session.getVisitId());
        DTLogger.INSTANCE.info("Starting new session with visit id: " + session.getVisitId());
        return session;
    }

    @Override
    public void updateVisitId(long visitorId, long sessionId, @Nullable Integer sequenceNumber) {
        VisitIdHelper visitIdHelper = new VisitIdHelper(visitorId, sessionId, sequenceNumber);
        String oldVisitId = this.trackingState.getCurrentVisitId();
        String newVisitId = visitIdHelper.getVisitId();
        if (oldVisitId != null) {
            DTLogger.INSTANCE.info("Update new session with visit id " + newVisitId);
            this.contextExecutor.execute((Function1<? super Context, Unit>)((Function1)new Function1<Context, Unit>(this, oldVisitId, newVisitId){
                final /* synthetic */ ConfigurationHandlerImpl this$0;
                final /* synthetic */ String $oldVisitId;
                final /* synthetic */ String $newVisitId;
                {
                    this.this$0 = $receiver;
                    this.$oldVisitId = $oldVisitId;
                    this.$newVisitId = $newVisitId;
                    super(1);
                }

                public final void invoke(@NotNull Context context) {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    ConfigurationHandlerImpl.access$getTaskManager$p(this.this$0).enqueueTask(context, TaskKt.updateVisitIdTask(new UpdateSessionVisitIdUseCase.Params(this.$oldVisitId, this.$newVisitId)));
                    ConfigurationHandlerImpl.access$getTrackingState$p(this.this$0).setCurrentVisitId(this.$newVisitId);
                }
            }));
        }
    }

    @Override
    public void updateServerId(int serverId) {
        this.contextExecutor.execute((Function1<? super Context, Unit>)((Function1)new Function1<Context, Unit>(this, serverId){
            final /* synthetic */ ConfigurationHandlerImpl this$0;
            final /* synthetic */ int $serverId;
            {
                this.this$0 = $receiver;
                this.$serverId = $serverId;
                super(1);
            }

            public final void invoke(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                ConfigurationHandlerImpl.access$getTaskManager$p(this.this$0).enqueueTask(context, TaskKt.saveServerIdTask(new SaveServerIdUseCase.Params(this.$serverId)));
            }
        }));
    }

    @Override
    public void updateServerConfiguration(@NotNull ReplayServerConfig replayServerConfig) {
        Intrinsics.checkNotNullParameter((Object)replayServerConfig, (String)"replayServerConfig");
        SessionReplayManager.INSTANCE.setPixelCopyEnabled$agent_release(replayServerConfig.getPixelCopyEnabled());
        SessionReplayManager.INSTANCE.setColorMasking$agent_release(replayServerConfig.getColorMaskingEnabled());
        this.contextExecutor.execute((Function1<? super Context, Unit>)((Function1)new Function1<Context, Unit>(this, replayServerConfig){
            final /* synthetic */ ConfigurationHandlerImpl this$0;
            final /* synthetic */ ReplayServerConfig $replayServerConfig;
            {
                this.this$0 = $receiver;
                this.$replayServerConfig = $replayServerConfig;
                super(1);
            }

            public final void invoke(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                ConfigurationHandlerImpl.access$getTaskManager$p(this.this$0).enqueueTask(context, TaskKt.saveServerConfigTask(new SaveServerConfigurationUseCase.Params(this.$replayServerConfig.getServerId(), this.$replayServerConfig.getRetentionTimeInMinutes(), this.$replayServerConfig.getMaxBeaconSizeKb(), this.$replayServerConfig.getDataProtocolVersion(), this.$replayServerConfig.getSelfMonitoring().getSelfmonitoring(), this.$replayServerConfig.getPixelCopyEnabled(), this.$replayServerConfig.getColorMaskingEnabled())));
            }
        }));
    }

    @Override
    public void calculateSrParameter(@NotNull SrParamCalculator.NotificationType notificationType, @NotNull ServerConfiguration serverConfiguration, @NotNull Session rumSession, @NotNull Function2<? super SessionStateConfiguration, ? super String, Unit> onFinish) {
        Intrinsics.checkNotNullParameter((Object)((Object)notificationType), (String)"notificationType");
        Intrinsics.checkNotNullParameter((Object)serverConfiguration, (String)"serverConfiguration");
        Intrinsics.checkNotNullParameter((Object)rumSession, (String)"rumSession");
        Intrinsics.checkNotNullParameter(onFinish, (String)"onFinish");
        ReplayConfiguration replayConfig = serverConfiguration.getReplayConfiguration();
        Intrinsics.checkNotNull((Object)replayConfig);
        SessionStateConfiguration sessionStateConfig = this.generateSessionStateConfig(rumSession, replayConfig);
        String srParameter = this.srParamCalculator.calculate(notificationType, sessionStateConfig);
        onFinish.invoke((Object)sessionStateConfig, (Object)srParameter);
    }

    private final SessionStateConfiguration generateSessionStateConfig(Session rumSession, ReplayConfiguration replayConfig) {
        SessionStateConfiguration.Builder configurationBuilder = this.sessionStateConfigurationBuilder.withCrashReportingOptIn(rumSession.getPrivacyRules().getPrivacySettings().isCrashReportingOptedIn()).withCrashOptIn(rumSession.getPrivacyRules().getPrivacySettings().isCrashReplayOptedIn()).withScreenRecordOptIn(rumSession.getPrivacyRules().getPrivacySettings().isScreenRecordOptedIn()).withFullSessionConfigReceived(replayConfig.getFullSessionConfigReceived()).withCapture(replayConfig.isCaptureOn()).withCrashEnabled(replayConfig.getCrashesEnabled()).withTrafficControlPercentage(replayConfig.getTrafficControlPercentage());
        return configurationBuilder.build();
    }

    public static final /* synthetic */ TaskManager access$getTaskManager$p(ConfigurationHandlerImpl $this) {
        return $this.taskManager;
    }

    public static final /* synthetic */ DeviceResolutionProvider access$getDeviceResolutionProvider$p(ConfigurationHandlerImpl $this) {
        return $this.deviceResolutionProvider;
    }

    public static final /* synthetic */ com.dynatrace.android.sessionreplay.model.Session access$createNewSession(ConfigurationHandlerImpl $this, long visitorId, long sessionId, DeviceResolution deviceResolution, Integer sequenceNumber) {
        return $this.createNewSession(visitorId, sessionId, deviceResolution, sequenceNumber);
    }

    public static final /* synthetic */ TrackingState access$getTrackingState$p(ConfigurationHandlerImpl $this) {
        return $this.trackingState;
    }
}

