/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.executor.services;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import androidx.core.app.JobIntentService;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.ServiceMessenger;
import com.dynatrace.android.sessionreplay.core.configuration.ConfigurationController;
import com.dynatrace.android.sessionreplay.core.executor.Task;
import com.dynatrace.android.sessionreplay.core.executor.TaskExecutor;
import com.dynatrace.android.sessionreplay.core.executor.TaskType;
import com.dynatrace.android.sessionreplay.core.executor.services.SessionStopHandler;
import com.dynatrace.android.sessionreplay.core.executor.services.StoppableJobQueue;
import com.dynatrace.android.sessionreplay.core.injection.AgentInjection;
import java.io.Serializable;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\"\u0010\u0015\u001a\u00020\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/dynatrace/android/sessionreplay/core/executor/services/UseCaseQueueJobIntentService;", "Landroidx/core/app/JobIntentService;", "Lcom/dynatrace/android/sessionreplay/core/executor/services/StoppableJobQueue;", "()V", "configurationController", "Lcom/dynatrace/android/sessionreplay/core/configuration/ConfigurationController;", "sessionStopHandler", "Lcom/dynatrace/android/sessionreplay/core/executor/services/SessionStopHandler;", "taskExecutor", "Lcom/dynatrace/android/sessionreplay/core/executor/TaskExecutor;", "whitelistedTasks", "Ljava/util/HashSet;", "Lcom/dynatrace/android/sessionreplay/core/executor/TaskType;", "Lkotlin/collections/HashSet;", "inject", "", "onCreate", "onDestroy", "onHandleWork", "intent", "Landroid/content/Intent;", "onStartCommand", "", "flags", "startId", "stop", "getTask", "Lcom/dynatrace/android/sessionreplay/core/executor/Task;", "Companion", "agent_release"})
public final class UseCaseQueueJobIntentService
extends JobIntentService
implements StoppableJobQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private ConfigurationController configurationController;
    private TaskExecutor taskExecutor;
    private SessionStopHandler sessionStopHandler;
    @NotNull
    private final HashSet<TaskType> whitelistedTasks;
    @NotNull
    public static final String TASK = "task";
    public static final int JOB_ID = 956823457;
    private static boolean stopped;

    public UseCaseQueueJobIntentService() {
        TaskType[] taskTypeArray = new TaskType[]{TaskType.FLOW_STOP, TaskType.SAVE_SERVER_CONFIG, TaskType.SAVE_AGENT_CONFIG, TaskType.SAVE_TRANSMISSION_MODE};
        this.whitelistedTasks = SetsKt.hashSetOf((Object[])taskTypeArray);
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        int n;
        if (Build.VERSION.SDK_INT < 26) {
            PackageManager packageManager = this.getApplicationContext().getPackageManager();
            Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"getPackageManager(...)");
            PackageManager pm = packageManager;
            int hasPermission = pm.checkPermission("android.permission.WAKE_LOCK", this.getApplicationContext().getPackageName());
            if (hasPermission == 0) {
                n = super.onStartCommand(intent, flags, startId);
            } else {
                DTLogger.INSTANCE.error("The permission Manifest.permission.WAKE_LOCK is not granted, Mobile Session Replay will not work");
                n = 2;
            }
        } else {
            n = super.onStartCommand(intent, flags, startId);
        }
        return n;
    }

    public void onCreate() {
        this.inject();
        super.onCreate();
        SessionStopHandler sessionStopHandler = this.sessionStopHandler;
        if (sessionStopHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sessionStopHandler");
            sessionStopHandler = null;
        }
        StoppableJobQueue stoppableJobQueue = this;
        Context context = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
        sessionStopHandler.registerQueue(stoppableJobQueue, context);
    }

    public void onDestroy() {
        SessionStopHandler sessionStopHandler = this.sessionStopHandler;
        if (sessionStopHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sessionStopHandler");
            sessionStopHandler = null;
        }
        sessionStopHandler.unregisterQueue();
        super.onDestroy();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onHandleWork(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            Task task = this.getTask(intent);
            Task task2 = task;
            if ((task2 != null ? task2.getType() : null) == TaskType.RESET_EMERGENCY_STOP_STATUS) {
                stopped = false;
                return;
            }
            if (stopped) {
                Task task3 = task;
                if (!CollectionsKt.contains((Iterable)this.whitelistedTasks, (Object)((Object)(task3 != null ? task3.getType() : null)))) {
                    DTLogger.INSTANCE.warning("Service was previously stopped");
                    return;
                }
            }
            if (task == null) {
                DTLogger.INSTANCE.warning("Task is null.");
                ServiceMessenger.processIntent(intent);
                return;
            }
            TaskExecutor taskExecutor = this.taskExecutor;
            if (taskExecutor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"taskExecutor");
                taskExecutor = null;
            }
            taskExecutor.execute(task);
            ServiceMessenger.notifyTaskFinished(task.getType() == TaskType.TRACK_EVENT);
            return;
        }
        catch (Exception ex) {
            DTLogger.INSTANCE.error("Task intent processing failed with error: " + ex + ", ignoring task");
        }
    }

    @Override
    public void stop() {
        stopped = true;
    }

    private final Task getTask(Intent $this$getTask) {
        Bundle bundle = $this$getTask.getExtras();
        Serializable serializable = bundle != null ? bundle.getSerializable(TASK) : null;
        return serializable instanceof Task ? (Task)serializable : null;
    }

    private final void inject() {
        Context context = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
        AgentInjection.Companion.init(context);
        this.configurationController = new ConfigurationController((Context)this);
        this.taskExecutor = AgentInjection.Companion.get().getTaskExecutor();
        this.sessionStopHandler = AgentInjection.Companion.get().getSessionStopHandler();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/dynatrace/android/sessionreplay/core/executor/services/UseCaseQueueJobIntentService$Companion;", "", "()V", "JOB_ID", "", "TASK", "", "stopped", "", "agent_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

