/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.executor.services;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.executor.services.MessengerClient;
import com.dynatrace.android.sessionreplay.core.executor.services.MessengerCode;
import com.dynatrace.android.sessionreplay.core.executor.services.MessengerService;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000=\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t*\u0001\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u000fJ\b\u0010\u001a\u001a\u00020\u0013H\u0002J\u0006\u0010\u001b\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/dynatrace/android/sessionreplay/core/executor/services/MessengerClient;", "", "()V", "bound", "", "connection", "com/dynatrace/android/sessionreplay/core/executor/services/MessengerClient$connection$1", "Lcom/dynatrace/android/sessionreplay/core/executor/services/MessengerClient$connection$1;", "contextRef", "Ljava/lang/ref/WeakReference;", "Landroid/content/Context;", "messenger", "Landroid/os/Messenger;", "pendingMessages", "", "Lcom/dynatrace/android/sessionreplay/core/executor/services/MessengerCode;", "getPendingMessages", "()Ljava/util/List;", "bind", "", "context", "disableService", "enableService", "isServiceEnabled", "notify", "message", "sendMessages", "unbind", "agent_release"})
@SourceDebugExtension(value={"SMAP\nMessengerClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessengerClient.kt\ncom/dynatrace/android/sessionreplay/core/executor/services/MessengerClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1855#2,2:108\n*S KotlinDebug\n*F\n+ 1 MessengerClient.kt\ncom/dynatrace/android/sessionreplay/core/executor/services/MessengerClient\n*L\n38#1:108,2\n*E\n"})
public final class MessengerClient {
    @Nullable
    private Messenger messenger;
    private boolean bound;
    @Nullable
    private WeakReference<Context> contextRef;
    @NotNull
    private final List<MessengerCode> pendingMessages = new ArrayList();
    @NotNull
    private final connection.1 connection = new ServiceConnection(this){
        final /* synthetic */ MessengerClient this$0;
        {
            this.this$0 = $receiver;
        }

        public void onServiceConnected(@NotNull ComponentName className, @NotNull IBinder service) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            MessengerClient.access$setMessenger$p(this.this$0, new Messenger(service));
            MessengerClient.access$setBound$p(this.this$0, true);
            MessengerClient.access$sendMessages(this.this$0);
        }

        public void onServiceDisconnected(@NotNull ComponentName className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            MessengerClient.access$setMessenger$p(this.this$0, null);
            MessengerClient.access$setBound$p(this.this$0, false);
        }
    };

    @NotNull
    public final List<MessengerCode> getPendingMessages() {
        return this.pendingMessages;
    }

    private final void sendMessages() {
        block3: {
            Unit unit;
            Iterable $this$forEach$iv = this.pendingMessages;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MessengerCode message = (MessengerCode)((Object)element$iv);
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)Message.obtain(null, (int)message.getCode(), (int)0, (int)0), (String)"obtain(...)");
                try {
                    Message msg;
                    DTLogger.INSTANCE.info("MessengerClient sending message code: " + message.getCode());
                    Messenger messenger = this.messenger;
                    if (messenger == null) continue;
                    messenger.send(msg);
                }
                catch (RemoteException e) {
                    String string;
                    String string2 = string = e.getLocalizedMessage();
                    if (string2 == null) continue;
                    Intrinsics.checkNotNull((Object)string2);
                    String errorMessage = string;
                    boolean bl2 = false;
                    DTLogger.INSTANCE.error("MessengerClient send error: " + errorMessage);
                }
            }
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            this.pendingMessages.clear();
            Context context = this.contextRef;
            if (context == null || (context = (Context)context.get()) == null) break block3;
            Context context2 = context;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)context2);
            this.disableService(context2);
        }
    }

    public final void notify(@NotNull MessengerCode message) {
        block1: {
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)((Object)message), (String)"message");
            this.pendingMessages.add(message);
            if (this.bound) {
                this.sendMessages();
                return;
            }
            Context context = this.contextRef;
            if (context == null || (context = (Context)context.get()) == null) break block1;
            Context context2 = context;
            boolean bl = false;
            this.enableService(context2);
            Intent intent2 = intent = new Intent(context2, MessengerService.class);
            boolean bl2 = false;
            context2.bindService(intent2, (ServiceConnection)this.connection, 1);
        }
    }

    public final void disableService(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.isServiceEnabled(context)) {
            context.getPackageManager().setComponentEnabledSetting(new ComponentName(context, MessengerService.class), 2, 1);
        }
    }

    public final void enableService(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.isServiceEnabled(context)) {
            context.getPackageManager().setComponentEnabledSetting(new ComponentName(context, MessengerService.class), 1, 1);
        }
    }

    public final boolean isServiceEnabled(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ComponentName componentName = new ComponentName(context, MessengerService.class);
        return context.getPackageManager().getComponentEnabledSetting(componentName) == 1;
    }

    public final void bind(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.bound) {
            return;
        }
        this.contextRef = new WeakReference<Context>(context);
    }

    public final void unbind() {
        if (!this.bound) {
            return;
        }
        Context context = this.contextRef;
        if (context != null && (context = (Context)context.get()) != null) {
            context.unbindService((ServiceConnection)this.connection);
        }
        this.bound = false;
    }

    public static final /* synthetic */ void access$setMessenger$p(MessengerClient $this, Messenger messenger) {
        $this.messenger = messenger;
    }

    public static final /* synthetic */ void access$setBound$p(MessengerClient $this, boolean bl) {
        $this.bound = bl;
    }

    public static final /* synthetic */ void access$sendMessages(MessengerClient $this) {
        $this.sendMessages();
    }
}

