/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.executor;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.executor.Task;
import com.dynatrace.android.sessionreplay.core.executor.TaskExecutor;
import com.dynatrace.android.sessionreplay.core.executor.TaskType;
import com.dynatrace.android.sessionreplay.core.injection.ComplexUseCaseFactory;
import com.dynatrace.android.sessionreplay.core.injection.DataAccessUseCaseFactory;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.utils.ExtensionsKt;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\b*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/dynatrace/android/sessionreplay/core/executor/TaskExecutorImpl;", "Lcom/dynatrace/android/sessionreplay/core/executor/TaskExecutor;", "dataAccessUseCaseFactory", "Lcom/dynatrace/android/sessionreplay/core/injection/DataAccessUseCaseFactory;", "complexUseCaseFactory", "Lcom/dynatrace/android/sessionreplay/core/injection/ComplexUseCaseFactory;", "(Lcom/dynatrace/android/sessionreplay/core/injection/DataAccessUseCaseFactory;Lcom/dynatrace/android/sessionreplay/core/injection/ComplexUseCaseFactory;)V", "execute", "", "task", "Lcom/dynatrace/android/sessionreplay/core/executor/Task;", "startWithParams", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "params", "Ljava/io/Serializable;", "agent_release"})
public final class TaskExecutorImpl
implements TaskExecutor {
    @NotNull
    private final DataAccessUseCaseFactory dataAccessUseCaseFactory;
    @NotNull
    private final ComplexUseCaseFactory complexUseCaseFactory;

    public TaskExecutorImpl(@NotNull DataAccessUseCaseFactory dataAccessUseCaseFactory, @NotNull ComplexUseCaseFactory complexUseCaseFactory) {
        Intrinsics.checkNotNullParameter((Object)dataAccessUseCaseFactory, (String)"dataAccessUseCaseFactory");
        Intrinsics.checkNotNullParameter((Object)complexUseCaseFactory, (String)"complexUseCaseFactory");
        this.dataAccessUseCaseFactory = dataAccessUseCaseFactory;
        this.complexUseCaseFactory = complexUseCaseFactory;
    }

    @Override
    public void execute(@NotNull Task task) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        DTLogger.INSTANCE.info("Executing task: " + task);
        switch (WhenMappings.$EnumSwitchMapping$0[task.getType().ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                this.startWithParams(this.complexUseCaseFactory.getTrackEventUseCase(), task.getParams());
                unit = Unit.INSTANCE;
                break;
            }
            case 3: {
                this.startWithParams(this.complexUseCaseFactory.getTrackRageTapUseCase(), task.getParams());
                unit = Unit.INSTANCE;
                break;
            }
            case 4: {
                this.startWithParams(this.dataAccessUseCaseFactory.getSaveLogUseCase(), task.getParams());
                unit = Unit.INSTANCE;
                break;
            }
            case 5: {
                this.startWithParams(this.dataAccessUseCaseFactory.getSaveServerIdUseCase(), task.getParams());
                unit = Unit.INSTANCE;
                break;
            }
            case 6: {
                this.startWithParams(this.dataAccessUseCaseFactory.getSaveAgentConfigurationUseCase(), task.getParams());
                unit = Unit.INSTANCE;
                break;
            }
            case 7: {
                this.startWithParams(this.dataAccessUseCaseFactory.getSaveServerConfigurationUseCase(), task.getParams());
                unit = Unit.INSTANCE;
                break;
            }
            case 8: {
                this.startWithParams(this.dataAccessUseCaseFactory.getSaveTransmissionModeUseCase(), task.getParams());
                unit = Unit.INSTANCE;
                break;
            }
            case 9: {
                this.startWithParams(this.dataAccessUseCaseFactory.getUpdateSessionVisitIdUseCase(), task.getParams());
                unit = Unit.INSTANCE;
                break;
            }
            case 10: {
                this.startWithParams(this.dataAccessUseCaseFactory.getUpdateSessionStateUseCase(), task.getParams());
                unit = Unit.INSTANCE;
                break;
            }
            case 11: {
                this.startWithParams(this.complexUseCaseFactory.getNewSessionFlow(), task.getParams());
                unit = Unit.INSTANCE;
                break;
            }
            case 12: {
                this.startWithParams(this.complexUseCaseFactory.getSchedulerFlow(), task.getParams());
                unit = Unit.INSTANCE;
                break;
            }
            case 13: {
                this.startWithParams(this.complexUseCaseFactory.getCrashFlow(), task.getParams());
                unit = Unit.INSTANCE;
                break;
            }
            case 14: {
                this.startWithParams(this.complexUseCaseFactory.getAppBackgroundedFlow(), task.getParams());
                unit = Unit.INSTANCE;
                break;
            }
            case 15: {
                this.startWithParams(this.complexUseCaseFactory.getStopFlow(), task.getParams());
                unit = Unit.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ExtensionsKt.getExhaustive(unit);
    }

    private final void startWithParams(UseCase<?, ?> $this$startWithParams, Serializable params) {
        Intrinsics.checkNotNull($this$startWithParams, (String)"null cannot be cast to non-null type com.dynatrace.android.sessionreplay.core.usecases.UseCase<java.io.Serializable?, kotlin.Any>");
        $this$startWithParams.start(params);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TaskType.values().length];
            try {
                nArray[TaskType.RESET_EMERGENCY_STOP_STATUS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskType.TRACK_EVENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskType.TRACK_RAGE_TAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskType.SAVE_LOG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskType.SAVE_SERVER_ID.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskType.SAVE_AGENT_CONFIG.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskType.SAVE_SERVER_CONFIG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskType.SAVE_TRANSMISSION_MODE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskType.UPDATE_VISIT_ID.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskType.UPDATE_SESSION_STATE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskType.FLOW_NEW_SESSION.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskType.FLOW_SCHEDULER.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskType.FLOW_CRASH.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskType.FLOW_APP_BACKGROUNDED.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskType.FLOW_STOP.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

