/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.connection.restclient;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.connection.restclient.Response;
import com.dynatrace.android.sessionreplay.core.connection.restclient.RestClient;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JH\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0011*\u00020\fH\u0002J \u0010\u0019\u001a\u00020\u001a*\u00020\f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J\f\u0010\u001b\u001a\u00020\u0004*\u00020\u0004H\u0002J\u0014\u0010\u001c\u001a\u00020\u001a*\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/dynatrace/android/sessionreplay/core/connection/restclient/SyncRestClient;", "Lcom/dynatrace/android/sessionreplay/core/connection/restclient/RestClient;", "()V", "buildParams", "", "params", "", "buildURL", "Ljava/net/URL;", "serverUrl", "queryParams", "openConnection", "Ljava/net/HttpURLConnection;", "url", "certificateValidation", "", "post", "Lcom/dynatrace/android/sessionreplay/core/connection/restclient/Response;", "body", "", "headers", "readBody", "inputStream", "Ljava/io/InputStream;", "readResponse", "setHeaders", "", "utf8", "writeBody", "Companion", "agent_release"})
@SourceDebugExtension(value={"SMAP\nSyncRestClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncRestClient.kt\ncom/dynatrace/android/sessionreplay/core/connection/restclient/SyncRestClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,119:1\n125#2:120\n152#2,3:121\n215#2,2:124\n*S KotlinDebug\n*F\n+ 1 SyncRestClient.kt\ncom/dynatrace/android/sessionreplay/core/connection/restclient/SyncRestClient\n*L\n54#1:120\n54#1:121,3\n69#1:124,2\n*E\n"})
public final class SyncRestClient
implements RestClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int CODE_RANGE_CLIENT_ERROR = 400;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Response post(@NotNull String serverUrl, @NotNull byte[] body, @NotNull Map<String, String> queryParams, @NotNull Map<String, String> headers, boolean certificateValidation) {
        Response response;
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        try {
            uRL = this.buildURL(serverUrl, queryParams);
        }
        catch (MalformedURLException e) {
            return new Response.Error.InvalidParameter("Invalid serverUrl");
        }
        URL url = uRL;
        HttpURLConnection $this$post_u24lambda_u240 = this.openConnection(url, certificateValidation);
        boolean bl = false;
        $this$post_u24lambda_u240.setRequestMethod("POST");
        this.setHeaders($this$post_u24lambda_u240, headers);
        try {
            this.writeBody($this$post_u24lambda_u240, body);
            response = this.readResponse($this$post_u24lambda_u240);
        }
        catch (IOException e) {
            DTLogger.INSTANCE.error("POST request failed with exception: " + e.getLocalizedMessage());
            response = new Response.Error.NetworkError(e);
        }
        finally {
            $this$post_u24lambda_u240.disconnect();
        }
        return response;
    }

    private final URL buildURL(String serverUrl, Map<String, String> queryParams) {
        return queryParams.isEmpty() ? new URL(serverUrl) : new URL(serverUrl + '?' + this.buildParams(queryParams));
    }

    /*
     * WARNING - void declaration
     */
    private final String buildParams(Map<String, String> params) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = params;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            collection.add(this.utf8(key) + '=' + this.utf8(value));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readBody(InputStream inputStream) {
        StringBuffer responseBody = new StringBuffer();
        Closeable closeable = new BufferedReader(new InputStreamReader(inputStream));
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            String inputLine = it.readLine();
            while (inputLine != null) {
                responseBody.append(inputLine);
                inputLine = it.readLine();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string = responseBody.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void setHeaders(HttpURLConnection $this$setHeaders, Map<String, String> headers) {
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            String value = entry.getValue();
            $this$setHeaders.setRequestProperty(key, value);
        }
    }

    private final Response readResponse(HttpURLConnection $this$readResponse) {
        if ($this$readResponse.getResponseCode() >= 400) {
            int n = $this$readResponse.getResponseCode();
            InputStream inputStream = $this$readResponse.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
            return new Response.Error.ServerError(n, this.readBody(inputStream));
        }
        int n = $this$readResponse.getResponseCode();
        InputStream inputStream = $this$readResponse.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        return new Response.Success(n, this.readBody(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeBody(HttpURLConnection $this$writeBody, byte[] body) {
        $this$writeBody.setDoOutput(true);
        $this$writeBody.setFixedLengthStreamingMode(body.length);
        Closeable closeable = new DataOutputStream($this$writeBody.getOutputStream());
        Throwable throwable = null;
        try {
            DataOutputStream it = (DataOutputStream)closeable;
            boolean bl = false;
            it.write(body);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final HttpURLConnection openConnection(URL url, boolean certificateValidation) {
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        return (HttpURLConnection)uRLConnection;
    }

    private final String utf8(String $this$utf8) {
        String string = URLEncoder.encode($this$utf8, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/dynatrace/android/sessionreplay/core/connection/restclient/SyncRestClient$Companion;", "", "()V", "CODE_RANGE_CLIENT_ERROR", "", "agent_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

