/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.connection;

import com.dynatrace.android.agent.Version;
import com.dynatrace.android.sessionreplay.core.configuration.AgentConfiguration;
import com.dynatrace.android.sessionreplay.core.connection.DynatraceAPIService;
import com.dynatrace.android.sessionreplay.core.connection.restclient.Response;
import com.dynatrace.android.sessionreplay.core.connection.restclient.RestClient;
import com.dynatrace.android.sessionreplay.core.utils.UtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/dynatrace/android/sessionreplay/core/connection/SyncDynatraceAPIService;", "Lcom/dynatrace/android/sessionreplay/core/connection/DynatraceAPIService;", "restClient", "Lcom/dynatrace/android/sessionreplay/core/connection/restclient/RestClient;", "agentConfig", "Lcom/dynatrace/android/sessionreplay/core/configuration/AgentConfiguration;", "(Lcom/dynatrace/android/sessionreplay/core/connection/restclient/RestClient;Lcom/dynatrace/android/sessionreplay/core/configuration/AgentConfiguration;)V", "sendBeacon", "Lcom/dynatrace/android/sessionreplay/core/connection/restclient/Response;", "params", "Lcom/dynatrace/android/sessionreplay/core/connection/DynatraceAPIService$DynatraceAPIParams;", "Companion", "agent_release"})
public final class SyncDynatraceAPIService
implements DynatraceAPIService {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final RestClient restClient;
    @NotNull
    private final AgentConfiguration agentConfig;
    @Deprecated
    @NotNull
    public static final String CONTENT_TYPE_BINARY = "application/octet-stream";
    @Deprecated
    @NotNull
    public static final String CONNECTION_KEEP_ALIVE = "keep-alive";
    @Deprecated
    @NotNull
    public static final String CONNECTION_CLOSE = "close";

    public SyncDynatraceAPIService(@NotNull RestClient restClient, @NotNull AgentConfiguration agentConfig) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter((Object)agentConfig, (String)"agentConfig");
        this.restClient = restClient;
        this.agentConfig = agentConfig;
    }

    @Override
    @NotNull
    public Response sendBeacon(@NotNull DynatraceAPIService.DynatraceAPIParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String appId = this.agentConfig.getAppId();
        CharSequence charSequence = appId;
        if (charSequence == null || charSequence.length() == 0) {
            return new Response.Error.InvalidParameter("appId is null or empty");
        }
        String serverUrl = this.agentConfig.getServerUrl();
        CharSequence charSequence2 = serverUrl;
        if (charSequence2 == null || charSequence2.length() == 0) {
            return new Response.Error.InvalidParameter("serverUrl is null or empty");
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"m"), TuplesKt.to((Object)"pt", (Object)"2"), TuplesKt.to((Object)"cts", (Object)"0"), TuplesKt.to((Object)"resp", (Object)"json"), TuplesKt.to((Object)"tt", (Object)"mraandroid"), TuplesKt.to((Object)"srvid", (Object)String.valueOf(this.agentConfig.getServerId())), TuplesKt.to((Object)"app", (Object)appId), TuplesKt.to((Object)"va", (Object)Version.getFullVersion()), TuplesKt.to((Object)"tx", (Object)String.valueOf(UtilsKt.currentTime())), TuplesKt.to((Object)"si", (Object)params.getVisitId())};
        Map queryParams = MapsKt.mapOf((Pair[])pairArray);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)CONTENT_TYPE_BINARY), TuplesKt.to((Object)"Connection", (Object)(params.getKeepConnectionAlive() ? CONNECTION_KEEP_ALIVE : CONNECTION_CLOSE)), TuplesKt.to((Object)"Content-Length", (Object)String.valueOf(params.getData().length))};
        Map headers = MapsKt.mapOf((Pair[])pairArray2);
        return this.restClient.post(serverUrl, params.getData(), queryParams, headers, this.agentConfig.isCertificateValidationEnabled());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/dynatrace/android/sessionreplay/core/connection/SyncDynatraceAPIService$Companion;", "", "()V", "CONNECTION_CLOSE", "", "CONNECTION_KEEP_ALIVE", "CONTENT_TYPE_BINARY", "agent_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

