/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.connection;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.dynatrace.android.sessionreplay.core.connection.NetworkStatus;
import com.dynatrace.android.sessionreplay.core.connection.NetworkStatusProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/dynatrace/android/sessionreplay/core/connection/ConnectivityChangeBroadcastReceiver;", "Landroid/content/BroadcastReceiver;", "networkStatusProvider", "Lcom/dynatrace/android/sessionreplay/core/connection/NetworkStatusProvider;", "(Lcom/dynatrace/android/sessionreplay/core/connection/NetworkStatusProvider;)V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "agent_release"})
public final class ConnectivityChangeBroadcastReceiver
extends BroadcastReceiver {
    @NotNull
    private final NetworkStatusProvider networkStatusProvider;

    public ConnectivityChangeBroadcastReceiver(@NotNull NetworkStatusProvider networkStatusProvider) {
        Intrinsics.checkNotNullParameter((Object)networkStatusProvider, (String)"networkStatusProvider");
        this.networkStatusProvider = networkStatusProvider;
    }

    public void onReceive(@NotNull Context context, @Nullable Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        ConnectivityManager cm = (ConnectivityManager)object;
        PackageManager packageManager = context.getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"getPackageManager(...)");
        PackageManager pm = packageManager;
        int hasPermission = pm.checkPermission("android.permission.ACCESS_NETWORK_STATE", context.getPackageName());
        if (hasPermission == 0) {
            NetworkInfo networkInfo;
            NetworkInfo networkInfo2 = networkInfo = cm.getActiveNetworkInfo();
            boolean internet = networkInfo2 != null ? networkInfo2.isConnected() : false;
            boolean metered = cm.isActiveNetworkMetered();
            this.networkStatusProvider.setNetworkStatus(NetworkStatus.Companion.getNetworkStatus(internet, metered));
        }
    }
}

