/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.mixed;

import android.app.Application;
import com.dynatrace.agent.OneAgentConfiguration;
import com.dynatrace.agent.OneAgentStartup;
import com.dynatrace.agent.RumEventDispatcher;
import com.dynatrace.agent.api.OneAgentFacade;
import com.dynatrace.agent.common.time.TimeProvider;
import com.dynatrace.agent.communication.api.AgentState;
import com.dynatrace.agent.di.CoreComponent;
import com.dynatrace.agent.di.SecondGenServiceLocator;
import com.dynatrace.agent.metrics.MetricsRepository;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.communication.CommunicationManagerBridge;
import com.dynatrace.android.agent.communication.ServerConfigurationListener;
import com.dynatrace.android.agent.conf.ConfigurationPublisher;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.lifecycle.OneAgentLifecycleManagerBridge;
import com.dynatrace.android.agent.mixed.AgentServiceLocator;
import com.dynatrace.android.agent.useraction.OneAgentUserInteractionManagerBridge;
import com.dynatrace.android.agent.util.Utility;
import okhttp3.Call;

public class AgentServiceLocatorImpl
implements AgentServiceLocator {
    private final OneAgentConfiguration oneAgentConfiguration;
    private final TimeProvider timeProvider;
    private final Application applicationContext;
    private final Call.Factory httpFactory;
    private final SecondGenServiceLocator secondGenServiceLocator;

    public AgentServiceLocatorImpl(OneAgentConfiguration oneAgentConfiguration, TimeProvider timeProvider, Application applicationContext, Call.Factory httpFactory, SecondGenServiceLocator secondGenServiceLocator) {
        this.oneAgentConfiguration = oneAgentConfiguration;
        this.timeProvider = timeProvider;
        this.applicationContext = applicationContext;
        this.httpFactory = httpFactory;
        this.secondGenServiceLocator = secondGenServiceLocator;
    }

    @Override
    public void init(ConfigurationPublisher configurationPublisher) {
        Utility.devLog((String)"dtxStartStop", (String)("initialize OneAgent, oneAgentConfiguration: " + this.oneAgentConfiguration + " httpFactory: " + this.httpFactory));
        CoreComponent.Holder.initComponent(this.oneAgentConfiguration, this.timeProvider, new ServerConfigurationListener(){

            public void onServerConfigurationChanged(ServerConfiguration configurationV3) {
                Core.applyConfigurationFromOneAgent(configurationV3);
            }

            public void onAgentStateChanged(AgentState state) {
                Core.applyAgentStateFromOneAgent(state);
            }
        }, this.httpFactory, this.applicationContext, this.secondGenServiceLocator, configurationPublisher);
    }

    @Override
    public CommunicationManagerBridge provideCommunicationManagerBridge() {
        return CoreComponent.Holder.getInstance().getCommunicationManagerBridge();
    }

    @Override
    public OneAgentLifecycleManagerBridge provideOneAgentLifecycleManagerBridge() {
        return CoreComponent.Holder.getInstance().getOneAgentLifecycleManagerBridge();
    }

    @Override
    public OneAgentUserInteractionManagerBridge provideOneAgentUserInteractionManagerBridge() {
        return CoreComponent.Holder.getInstance().getOneAgentUserInteractionManagerBridge();
    }

    @Override
    public OneAgentStartup provideOneAgentStartup() {
        return CoreComponent.Holder.getInstance().getOneAgentStartup();
    }

    @Override
    public RumEventDispatcher provideRumEventDispatcher() {
        return CoreComponent.Holder.getInstance().getRumEventDispatcher();
    }

    @Override
    public OneAgentFacade provideOneAgentFacade() {
        return CoreComponent.Holder.getInstance().getOneAgentFacade();
    }

    @Override
    public MetricsRepository provideMetricsRepository() {
        CoreComponent coreComponent = CoreComponent.Holder.getInstance();
        if (coreComponent != null) {
            return coreComponent.getMetricsRepository();
        }
        return null;
    }

    @Override
    public void shutdown() {
        CoreComponent.Holder.tearDown();
    }
}

