/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.metrics;

import android.content.Context;
import android.os.BatteryManager;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;

public class BatteryTracker {
    private static final String LOG_TAG = "BatteryTracker";
    private final BatteryManager batteryManager;

    BatteryTracker(BatteryManager batteryManager) {
        this.batteryManager = batteryManager;
    }

    public static BatteryTracker generateBatteryTracker(Context context) {
        try {
            BatteryManager batteryManager = (BatteryManager)context.getSystemService("batterymanager");
            if (batteryManager == null) {
                if (Global.DEBUG) {
                    Utility.zlogD((String)LOG_TAG, (String)"unable to track the battery service");
                }
                return null;
            }
            return new BatteryTracker(batteryManager);
        }
        catch (Exception e) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOG_TAG, (String)"unable to track the battery service", (Throwable)e);
            }
            return null;
        }
    }

    public int captureBatteryLevel() {
        try {
            int value = this.batteryManager.getIntProperty(4);
            if (value < 0 || value > 100) {
                if (Global.DEBUG) {
                    Utility.zlogD((String)LOG_TAG, (String)("invalid battery level '" + value + "' detected"));
                }
                return Integer.MIN_VALUE;
            }
            return value;
        }
        catch (Exception e) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOG_TAG, (String)"unable to determine the battery level", (Throwable)e);
            }
            return Integer.MIN_VALUE;
        }
    }
}

