/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.agent.OneAgentStartupEventDispatcher;
import com.dynatrace.agent.di.CoreComponent;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.conf.ConfigurationPublisher;
import com.dynatrace.android.agent.conf.ConfigurationSubscriber;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.mixed.SessionInformationGenerator;
import com.dynatrace.android.agent.util.Utility;
import java.util.List;
import org.json.JSONObject;

final class HybridBridge {
    private HybridBridge() {
    }

    static void forwardEvent(JSONObject rumEvent) {
        Utility.devLog((String)"dtxEventGeneration", (String)"forward a JSON event to the enrichment pipeline");
        CoreComponent coreComponent = CoreComponent.Holder.getInstance();
        Session session = Session.determineActiveSessionForInternalEvent();
        if (HybridBridge.isEventCanBeSent(rumEvent, coreComponent, session)) {
            coreComponent.getRumEventDispatcher().dispatchEvent(rumEvent, SessionInformationGenerator.generate(session), null);
        }
    }

    static void forwardAppStartEvent(JSONObject rumEvent, List<String> keys) {
        Utility.devLog((String)"dtxEventGeneration", (String)"forward a JSON app start event to the enrichment pipeline");
        CoreComponent coreComponent = CoreComponent.Holder.getInstance();
        Session session = Session.determineActiveSessionForInternalEvent();
        if (HybridBridge.isEventCanBeSent(rumEvent, coreComponent, session)) {
            OneAgentStartupEventDispatcher startupEventDispatcher = coreComponent.getOneAgentStartupEventDispatcher();
            startupEventDispatcher.dispatchCrossPlatformEvent(rumEvent, SessionInformationGenerator.generate(session), keys);
        }
    }

    static void addConfigurationSubscriber(ConfigurationSubscriber subscriber) {
        ConfigurationPublisher publisher = Core.getConfigurationPublisher();
        publisher.register(subscriber);
    }

    private static boolean isEventCanBeSent(JSONObject rumEvent, CoreComponent coreComponent, Session session) {
        if (!Dynatrace.getCaptureStatus()) {
            Utility.devLog((String)"dtxEventGeneration", (String)"forward event not possible, capturing is disabled");
            return false;
        }
        if (rumEvent == null) {
            Utility.devLog((String)"dtxEventGeneration", (String)"cannot forward a hybrid JSON event that is 'null'");
            return false;
        }
        if (coreComponent == null) {
            Utility.devLog((String)"dtxEventGeneration", (String)"cannot forward a hybrid JSON event because agent is not set up yet");
            return false;
        }
        if (session == null || !session.isActive() || !session.isGrailEventsShouldBeCaptured()) {
            Utility.devLog((String)"dtxEventGeneration", (String)"current session is 'null' or cannot accept Grail events");
            return false;
        }
        return true;
    }
}

